/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.servlet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.server.manager.internal.executor.Executor;
import com.liferay.server.manager.internal.executor.ExecutorPathResolver;
import com.liferay.server.manager.internal.executor.ExecutorServiceRegistry;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.server.manager.internal.servlet.ServerManagerServlet", "osgi.http.whiteboard.servlet.pattern=/server-manager/*", "servlet.init.httpMethods=DELETE,GET,POST,PUT"}, service={Servlet.class})
public class ServerManagerServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(ServerManagerServlet.class);
    @Reference
    private ExecutorServiceRegistry _executorServiceRegistry;
    @Reference
    private Portal _portal;

    protected void execute(HttpServletRequest httpServletRequest, JSONObject responseJSONObject, String pathInfo) throws Exception {
        String executorPath = this.getExecutorPath(pathInfo);
        Executor executor = this._executorServiceRegistry.getExecutor(executorPath);
        Queue<String> arguments = this.getExecutorArguments(executorPath, pathInfo);
        String method = httpServletRequest.getMethod();
        if (StringUtil.equalsIgnoreCase((String)method, (String)"DELETE")) {
            executor.executeDelete(httpServletRequest, responseJSONObject, arguments);
        } else if (StringUtil.equalsIgnoreCase((String)method, (String)"GET")) {
            executor.executeRead(httpServletRequest, responseJSONObject, arguments);
        } else if (StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
            executor.executeCreate(httpServletRequest, responseJSONObject, arguments);
        } else if (StringUtil.equalsIgnoreCase((String)method, (String)"PUT")) {
            executor.executeUpdate(httpServletRequest, responseJSONObject, arguments);
        }
    }

    protected Queue<String> getExecutorArguments(String matchingExecutorPath, String pathInfo) {
        String[] pathParts;
        LinkedList<String> arguments = new LinkedList<String>();
        String path = StringUtil.toLowerCase((String)pathInfo);
        path = StringUtil.removeSubstring((String)path, (String)(matchingExecutorPath + "/"));
        for (String pathPart : pathParts = StringUtil.split((String)path, (String)"/")) {
            arguments.add(pathPart);
        }
        return arguments;
    }

    protected String getExecutorPath(String pathInfo) {
        ExecutorPathResolver executorPathResolver = new ExecutorPathResolver(this._executorServiceRegistry.getAvailableExecutorPaths());
        return executorPathResolver.getExecutorPath(pathInfo);
    }

    protected boolean isValidUser(HttpServletRequest httpServletRequest) {
        try {
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._portal.getUser(httpServletRequest));
            if (permissionChecker.isOmniadmin()) {
                return true;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return false;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!this.isValidUser(httpServletRequest)) {
            httpServletResponse.setStatus(401);
            return;
        }
        JSONObject responseJSONObject = JSONUtil.put((String)"error", (Object)"").put("output", "").put("status", 0);
        try {
            this.execute(httpServletRequest, responseJSONObject, httpServletRequest.getPathInfo());
        }
        catch (Exception exception) {
            responseJSONObject.put("error", StackTraceUtil.getStackTrace((Throwable)exception)).put("status", 1);
        }
        String format = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"format");
        if (format.equals("raw")) {
            httpServletResponse.setContentType("text/plain");
            String outputStream = responseJSONObject.getString("output");
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)outputStream);
        } else {
            httpServletResponse.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)responseJSONObject.toString());
        }
    }
}

