/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.server.manager.internal.executor.BaseExecutor;
import com.liferay.server.manager.internal.executor.Executor;
import com.liferay.server.manager.internal.executor.ExecutorPathResolver;
import com.liferay.server.manager.internal.executor.ExecutorServiceRegistry;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"server.manager.executor.path=/"}, service={Executor.class})
public class RootExecutor
extends BaseExecutor {
    @Reference
    private ExecutorServiceRegistry _executorServiceRegistry;
    private String _path;

    @Override
    public void executeRead(HttpServletRequest httpServletRequest, JSONObject responseJSONObject, Queue<String> arguments) throws Exception {
        ExecutorPathResolver executorPathResolver = new ExecutorPathResolver(this._executorServiceRegistry.getAvailableExecutorPaths());
        List<String> paths = executorPathResolver.getNextExecutorsPaths(this._path);
        responseJSONObject.put("output", "Valid paths are " + StringUtil.merge(paths, (String)", "));
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._path = MapUtil.getString(properties, (String)"server.manager.executor.path");
    }
}

