/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.server.manager.internal.executor.BaseExecutor;
import com.liferay.server.manager.internal.executor.Executor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Format;
import java.util.Date;
import java.util.Queue;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"server.manager.executor.path=/server/log/output"}, service={Executor.class})
public class OutputLogExecutor
extends BaseExecutor {
    @Reference
    private FastDateFormatFactory _fastDateFormatFactory;
    private Format _simpleDateFormat;

    @Override
    public void executeRead(HttpServletRequest request, JSONObject responseJSONObject, Queue<String> arguments) throws Exception {
        File logFile = this.getLogFile();
        if (logFile == null || !logFile.exists()) {
            return;
        }
        FileInputStream inputStream = new FileInputStream(logFile);
        int offset = GetterUtil.getInteger((String)arguments.poll());
        ((InputStream)inputStream).skip(offset);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream);
        responseJSONObject.put("output", ((Object)outputStream).toString());
    }

    @Activate
    protected void activate() {
        this._simpleDateFormat = this._fastDateFormatFactory.getSimpleDateFormat("yyyy-MM-dd");
    }

    protected String getLiferayDateString() {
        return this.getTomcatDateString();
    }

    protected File getLogFile() {
        File logFile = null;
        if (ServerDetector.isJBoss()) {
            File logDirectory = new File(System.getProperty("jboss.server.log.dir"));
            logFile = new File(logDirectory, "server.log");
        } else {
            logFile = new File(StringBundler.concat((String[])new String[]{PropsUtil.get((String)"liferay.home"), "/logs/liferay.", this.getLiferayDateString(), ".log"}));
        }
        return logFile;
    }

    protected String getTomcatDateString() {
        Date date = new Date();
        return this._simpleDateFormat.format(date);
    }
}

