/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.server.manager.internal.servlet.filter;

import com.liferay.portal.kernel.servlet.PortalClassLoaderFilter;

import javax.servlet.Filter;

import org.osgi.service.component.annotations.Component;

/**
 * @author Marcellus Tavares
 */
@Component(
	immediate = true,
	property = {
		"filter.init.basic_auth=true",
		"filter.init.filter-class=com.liferay.portal.servlet.filters.secure.SecureFilter",
		"filter.init.portal_property_prefix=server.manager.servlet.",
		"osgi.http.whiteboard.filter.name=com.liferay.server.manager.internal.servlet.filter.ServerManagerFilter",
		"osgi.http.whiteboard.filter.pattern=/server-manager/*"
	},
	service = Filter.class
)
public class ServerManagerFilter extends PortalClassLoaderFilter {
}