/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

/**
 * @author Marcellus Tavares
 */
@Component(immediate = true, service = ExecutorServiceRegistry.class)
public class ExecutorServiceRegistry {

	public Set<String> getAvailableExecutorPaths() {
		return Collections.unmodifiableSet(_executors.keySet());
	}

	public Executor getExecutor(String executorPath) {
		return _executors.get(executorPath);
	}

	@Reference(
		cardinality = ReferenceCardinality.MULTIPLE,
		policy = ReferencePolicy.DYNAMIC,
		policyOption = ReferencePolicyOption.GREEDY
	)
	protected synchronized void registerExecutor(
		Executor executor, Map<String, Object> properties) {

		String executorPath = MapUtil.getString(
			properties, "server.manager.executor.path");

		if (Validator.isNull(executorPath)) {
			throw new IllegalArgumentException(
				"The property \"server.manager.executor.path\" is null");
		}

		_executors.put(executorPath, executor);
	}

	protected synchronized void unregisterExecutor(
		Executor executor, Map<String, Object> properties) {

		String executorPath = MapUtil.getString(
			properties, "server.manager.executor.path");

		_executors.remove(executorPath);
	}

	private final Map<String, Executor> _executors = new HashMap<>();

}