/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.server.manager.internal.constants.JSONKeys;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.osgi.service.component.annotations.Component;

/**
 * @author Jonathan Potter
 * @author Brian Wing Shun Chan
 */
@Component(
	immediate = true,
	property = "server.manager.executor.path=/server/debug-port",
	service = Executor.class
)
public class DebugPortExecutor extends BaseExecutor {

	@Override
	public void executeRead(
		HttpServletRequest request, JSONObject responseJSONObject,
		Queue<String> arguments) {

		String debugPort = getDebugPort();

		if (debugPort == null) {
			responseJSONObject.put(
				JSONKeys.ERROR, "Server was not started in debug mode");
			responseJSONObject.put(JSONKeys.STATUS, 1);
		}
		else {
			responseJSONObject.put(JSONKeys.OUTPUT, debugPort);
		}
	}

	protected String getDebugPort() {
		RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();

		List<String> inputArguments = runtimeMXBean.getInputArguments();

		if (inputArguments == null) {
			return null;
		}

		for (String inputArgument : inputArguments) {
			if (!inputArgument.contains("transport=dt_socket")) {
				continue;
			}

			Matcher matcher = _pattern.matcher(inputArgument);

			if (matcher.find()) {
				return matcher.group(1);
			}
		}

		return null;
	}

	private final Pattern _pattern = Pattern.compile("address=(\\d+)");

}