/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.server.manager.internal.executor.Executor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ExecutorServiceRegistry.class})
public class ExecutorServiceRegistry {
    private final Map<String, Executor> _executors = new HashMap<String, Executor>();

    public Set<String> getAvailableExecutorPaths() {
        return Collections.unmodifiableSet(this._executors.keySet());
    }

    public Executor getExecutor(String executorPath) {
        return this._executors.get(executorPath);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unregisterExecutor")
    protected synchronized void registerExecutor(Executor executor, Map<String, Object> properties) {
        String executorPath = MapUtil.getString(properties, (String)"server.manager.executor.path");
        if (Validator.isNull((String)executorPath)) {
            throw new IllegalArgumentException("The property \"server.manager.executor.path\" is null");
        }
        this._executors.put(executorPath, executor);
    }

    protected synchronized void unregisterExecutor(Executor executor, Map<String, Object> properties) {
        String executorPath = MapUtil.getString(properties, (String)"server.manager.executor.path");
        this._executors.remove(executorPath);
    }
}

