/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.segments.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperienceModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SegmentsExperience service. Represents a row in the &quot;SegmentsExperience&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SegmentsExperienceModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SegmentsExperienceImpl}.
 * </p>
 *
 * @author Eduardo Garcia
 * @see SegmentsExperienceImpl
 * @generated
 */
@JSON(strict = true)
public class SegmentsExperienceModelImpl
	extends BaseModelImpl<SegmentsExperience>
	implements SegmentsExperienceModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a segments experience model instance should use the <code>SegmentsExperience</code> interface instead.
	 */
	public static final String TABLE_NAME = "SegmentsExperience";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"segmentsExperienceId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"segmentsEntryId", Types.BIGINT},
		{"segmentsExperienceKey", Types.VARCHAR}, {"plid", Types.BIGINT},
		{"name", Types.VARCHAR}, {"priority", Types.INTEGER},
		{"active_", Types.BOOLEAN}, {"typeSettings", Types.VARCHAR},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("segmentsExperienceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("segmentsEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("segmentsExperienceKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("typeSettings", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SegmentsExperience (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,segmentsExperienceId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,segmentsEntryId LONG,segmentsExperienceKey VARCHAR(75) null,plid LONG,name STRING null,priority INTEGER,active_ BOOLEAN,typeSettings VARCHAR(75) null,lastPublishDate DATE null,primary key (segmentsExperienceId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table SegmentsExperience";

	public static final String ORDER_BY_JPQL =
		" ORDER BY segmentsExperience.priority DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SegmentsExperience.priority DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PLID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SEGMENTSENTRYID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SEGMENTSEXPERIENCEKEY_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public SegmentsExperienceModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _segmentsExperienceId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSegmentsExperienceId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _segmentsExperienceId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SegmentsExperience.class;
	}

	@Override
	public String getModelClassName() {
		return SegmentsExperience.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SegmentsExperience, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SegmentsExperience, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SegmentsExperience, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SegmentsExperience)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SegmentsExperience, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SegmentsExperience, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SegmentsExperience)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SegmentsExperience, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SegmentsExperience, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<SegmentsExperience, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<SegmentsExperience, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<SegmentsExperience, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", SegmentsExperience::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", SegmentsExperience::getCtCollectionId);
			attributeGetterFunctions.put("uuid", SegmentsExperience::getUuid);
			attributeGetterFunctions.put(
				"segmentsExperienceId",
				SegmentsExperience::getSegmentsExperienceId);
			attributeGetterFunctions.put(
				"groupId", SegmentsExperience::getGroupId);
			attributeGetterFunctions.put(
				"companyId", SegmentsExperience::getCompanyId);
			attributeGetterFunctions.put(
				"userId", SegmentsExperience::getUserId);
			attributeGetterFunctions.put(
				"userName", SegmentsExperience::getUserName);
			attributeGetterFunctions.put(
				"createDate", SegmentsExperience::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", SegmentsExperience::getModifiedDate);
			attributeGetterFunctions.put(
				"segmentsEntryId", SegmentsExperience::getSegmentsEntryId);
			attributeGetterFunctions.put(
				"segmentsExperienceKey",
				SegmentsExperience::getSegmentsExperienceKey);
			attributeGetterFunctions.put("plid", SegmentsExperience::getPlid);
			attributeGetterFunctions.put("name", SegmentsExperience::getName);
			attributeGetterFunctions.put(
				"priority", SegmentsExperience::getPriority);
			attributeGetterFunctions.put(
				"active", SegmentsExperience::getActive);
			attributeGetterFunctions.put(
				"typeSettings", SegmentsExperience::getTypeSettings);
			attributeGetterFunctions.put(
				"lastPublishDate", SegmentsExperience::getLastPublishDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<SegmentsExperience, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<SegmentsExperience, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<SegmentsExperience, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<SegmentsExperience, String>)
					SegmentsExperience::setUuid);
			attributeSetterBiConsumers.put(
				"segmentsExperienceId",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setSegmentsExperienceId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<SegmentsExperience, String>)
					SegmentsExperience::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<SegmentsExperience, Date>)
					SegmentsExperience::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<SegmentsExperience, Date>)
					SegmentsExperience::setModifiedDate);
			attributeSetterBiConsumers.put(
				"segmentsEntryId",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setSegmentsEntryId);
			attributeSetterBiConsumers.put(
				"segmentsExperienceKey",
				(BiConsumer<SegmentsExperience, String>)
					SegmentsExperience::setSegmentsExperienceKey);
			attributeSetterBiConsumers.put(
				"plid",
				(BiConsumer<SegmentsExperience, Long>)
					SegmentsExperience::setPlid);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<SegmentsExperience, String>)
					SegmentsExperience::setName);
			attributeSetterBiConsumers.put(
				"priority",
				(BiConsumer<SegmentsExperience, Integer>)
					SegmentsExperience::setPriority);
			attributeSetterBiConsumers.put(
				"active",
				(BiConsumer<SegmentsExperience, Boolean>)
					SegmentsExperience::setActive);
			attributeSetterBiConsumers.put(
				"typeSettings",
				(BiConsumer<SegmentsExperience, String>)
					SegmentsExperience::setTypeSettings);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<SegmentsExperience, Date>)
					SegmentsExperience::setLastPublishDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getSegmentsExperienceId() {
		return _segmentsExperienceId;
	}

	@Override
	public void setSegmentsExperienceId(long segmentsExperienceId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_segmentsExperienceId = segmentsExperienceId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getSegmentsEntryId() {
		return _segmentsEntryId;
	}

	@Override
	public void setSegmentsEntryId(long segmentsEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_segmentsEntryId = segmentsEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalSegmentsEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("segmentsEntryId"));
	}

	@JSON
	@Override
	public String getSegmentsExperienceKey() {
		if (_segmentsExperienceKey == null) {
			return "";
		}
		else {
			return _segmentsExperienceKey;
		}
	}

	@Override
	public void setSegmentsExperienceKey(String segmentsExperienceKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_segmentsExperienceKey = segmentsExperienceKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSegmentsExperienceKey() {
		return getColumnOriginalValue("segmentsExperienceKey");
	}

	@JSON
	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPlid() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("plid"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalPriority() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("priority"));
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public String getTypeSettings() {
		if (_typeSettings == null) {
			return "";
		}
		else {
			return _typeSettings;
		}
	}

	@Override
	public void setTypeSettings(String typeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeSettings = typeSettings;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(SegmentsExperience.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SegmentsExperience.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			SegmentsExperience.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public SegmentsExperience toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SegmentsExperience>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SegmentsExperienceImpl segmentsExperienceImpl =
			new SegmentsExperienceImpl();

		segmentsExperienceImpl.setMvccVersion(getMvccVersion());
		segmentsExperienceImpl.setCtCollectionId(getCtCollectionId());
		segmentsExperienceImpl.setUuid(getUuid());
		segmentsExperienceImpl.setSegmentsExperienceId(
			getSegmentsExperienceId());
		segmentsExperienceImpl.setGroupId(getGroupId());
		segmentsExperienceImpl.setCompanyId(getCompanyId());
		segmentsExperienceImpl.setUserId(getUserId());
		segmentsExperienceImpl.setUserName(getUserName());
		segmentsExperienceImpl.setCreateDate(getCreateDate());
		segmentsExperienceImpl.setModifiedDate(getModifiedDate());
		segmentsExperienceImpl.setSegmentsEntryId(getSegmentsEntryId());
		segmentsExperienceImpl.setSegmentsExperienceKey(
			getSegmentsExperienceKey());
		segmentsExperienceImpl.setPlid(getPlid());
		segmentsExperienceImpl.setName(getName());
		segmentsExperienceImpl.setPriority(getPriority());
		segmentsExperienceImpl.setActive(isActive());
		segmentsExperienceImpl.setTypeSettings(getTypeSettings());
		segmentsExperienceImpl.setLastPublishDate(getLastPublishDate());

		segmentsExperienceImpl.resetOriginalValues();

		return segmentsExperienceImpl;
	}

	@Override
	public SegmentsExperience cloneWithOriginalValues() {
		SegmentsExperienceImpl segmentsExperienceImpl =
			new SegmentsExperienceImpl();

		segmentsExperienceImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		segmentsExperienceImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		segmentsExperienceImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		segmentsExperienceImpl.setSegmentsExperienceId(
			this.<Long>getColumnOriginalValue("segmentsExperienceId"));
		segmentsExperienceImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		segmentsExperienceImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		segmentsExperienceImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		segmentsExperienceImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		segmentsExperienceImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		segmentsExperienceImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		segmentsExperienceImpl.setSegmentsEntryId(
			this.<Long>getColumnOriginalValue("segmentsEntryId"));
		segmentsExperienceImpl.setSegmentsExperienceKey(
			this.<String>getColumnOriginalValue("segmentsExperienceKey"));
		segmentsExperienceImpl.setPlid(
			this.<Long>getColumnOriginalValue("plid"));
		segmentsExperienceImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		segmentsExperienceImpl.setPriority(
			this.<Integer>getColumnOriginalValue("priority"));
		segmentsExperienceImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		segmentsExperienceImpl.setTypeSettings(
			this.<String>getColumnOriginalValue("typeSettings"));
		segmentsExperienceImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return segmentsExperienceImpl;
	}

	@Override
	public int compareTo(SegmentsExperience segmentsExperience) {
		int value = 0;

		if (getPriority() < segmentsExperience.getPriority()) {
			value = -1;
		}
		else if (getPriority() > segmentsExperience.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SegmentsExperience)) {
			return false;
		}

		SegmentsExperience segmentsExperience = (SegmentsExperience)object;

		long primaryKey = segmentsExperience.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SegmentsExperience> toCacheModel() {
		SegmentsExperienceCacheModel segmentsExperienceCacheModel =
			new SegmentsExperienceCacheModel();

		segmentsExperienceCacheModel.mvccVersion = getMvccVersion();

		segmentsExperienceCacheModel.ctCollectionId = getCtCollectionId();

		segmentsExperienceCacheModel.uuid = getUuid();

		String uuid = segmentsExperienceCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			segmentsExperienceCacheModel.uuid = null;
		}

		segmentsExperienceCacheModel.segmentsExperienceId =
			getSegmentsExperienceId();

		segmentsExperienceCacheModel.groupId = getGroupId();

		segmentsExperienceCacheModel.companyId = getCompanyId();

		segmentsExperienceCacheModel.userId = getUserId();

		segmentsExperienceCacheModel.userName = getUserName();

		String userName = segmentsExperienceCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			segmentsExperienceCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			segmentsExperienceCacheModel.createDate = createDate.getTime();
		}
		else {
			segmentsExperienceCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			segmentsExperienceCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			segmentsExperienceCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		segmentsExperienceCacheModel.segmentsEntryId = getSegmentsEntryId();

		segmentsExperienceCacheModel.segmentsExperienceKey =
			getSegmentsExperienceKey();

		String segmentsExperienceKey =
			segmentsExperienceCacheModel.segmentsExperienceKey;

		if ((segmentsExperienceKey != null) &&
			(segmentsExperienceKey.length() == 0)) {

			segmentsExperienceCacheModel.segmentsExperienceKey = null;
		}

		segmentsExperienceCacheModel.plid = getPlid();

		segmentsExperienceCacheModel.name = getName();

		String name = segmentsExperienceCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			segmentsExperienceCacheModel.name = null;
		}

		segmentsExperienceCacheModel.priority = getPriority();

		segmentsExperienceCacheModel.active = isActive();

		segmentsExperienceCacheModel.typeSettings = getTypeSettings();

		String typeSettings = segmentsExperienceCacheModel.typeSettings;

		if ((typeSettings != null) && (typeSettings.length() == 0)) {
			segmentsExperienceCacheModel.typeSettings = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			segmentsExperienceCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			segmentsExperienceCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return segmentsExperienceCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SegmentsExperience, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SegmentsExperience, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SegmentsExperience, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(SegmentsExperience)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SegmentsExperience>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					SegmentsExperience.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _segmentsExperienceId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _segmentsEntryId;
	private String _segmentsExperienceKey;
	private long _plid;
	private String _name;
	private String _nameCurrentLanguageId;
	private int _priority;
	private boolean _active;
	private String _typeSettings;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<SegmentsExperience, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SegmentsExperience)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"segmentsExperienceId", _segmentsExperienceId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("segmentsEntryId", _segmentsEntryId);
		_columnOriginalValues.put(
			"segmentsExperienceKey", _segmentsExperienceKey);
		_columnOriginalValues.put("plid", _plid);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("typeSettings", _typeSettings);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("segmentsExperienceId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("segmentsEntryId", 1024L);

		columnBitmasks.put("segmentsExperienceKey", 2048L);

		columnBitmasks.put("plid", 4096L);

		columnBitmasks.put("name", 8192L);

		columnBitmasks.put("priority", 16384L);

		columnBitmasks.put("active_", 32768L);

		columnBitmasks.put("typeSettings", 65536L);

		columnBitmasks.put("lastPublishDate", 131072L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SegmentsExperience _escapedModel;

}