/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.provider;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.context.Context;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributorRegistry;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryRelModel;
import com.liferay.segments.odata.matcher.ODataMatcher;
import com.liferay.segments.odata.retriever.ODataRetriever;
import com.liferay.segments.provider.SegmentsEntryProvider;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSegmentsEntryProvider
implements SegmentsEntryProvider {
    @Reference(target="(target.class.name=com.liferay.segments.context.Context)")
    protected ODataMatcher<Context> oDataMatcher;
    @Reference
    protected Portal portal;
    @Reference
    protected SegmentsCriteriaContributorRegistry segmentsCriteriaContributorRegistry;
    @Reference
    protected SegmentsEntryLocalService segmentsEntryLocalService;
    @Reference
    protected SegmentsEntryRelLocalService segmentsEntryRelLocalService;
    protected ServiceTrackerMap<String, ODataRetriever<BaseModel<?>>> serviceTrackerMap;
    private static final Log _log = LogFactoryUtil.getLog(BaseSegmentsEntryProvider.class);

    public long[] getSegmentsEntryClassPKs(long segmentsEntryId, int start, int end) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            return new long[0];
        }
        String filterString = this.getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (Validator.isNull((String)filterString)) {
            return TransformUtil.transformToLongArray((Collection)this.segmentsEntryRelLocalService.getSegmentsEntryRels(segmentsEntryId, start, end, null), SegmentsEntryRelModel::getClassPK);
        }
        ODataRetriever oDataRetriever = (ODataRetriever)this.serviceTrackerMap.getService((Object)segmentsEntry.getType());
        if (oDataRetriever == null) {
            return new long[0];
        }
        return TransformUtil.transformToLongArray((Collection)oDataRetriever.getResults(segmentsEntry.getCompanyId(), filterString, LocaleUtil.getDefault(), start, end), baseModel -> (Long)baseModel.getPrimaryKeyObj());
    }

    public int getSegmentsEntryClassPKsCount(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            return 0;
        }
        String filterString = this.getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (Validator.isNull((String)filterString)) {
            return this.segmentsEntryRelLocalService.getSegmentsEntryRelsCount(segmentsEntryId);
        }
        ODataRetriever oDataRetriever = (ODataRetriever)this.serviceTrackerMap.getService((Object)segmentsEntry.getType());
        if (oDataRetriever == null) {
            return 0;
        }
        return oDataRetriever.getResultsCount(segmentsEntry.getCompanyId(), filterString, LocaleUtil.getDefault());
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context) throws PortalException {
        return this.getSegmentsEntryIds(groupId, className, classPK, context, new long[0], new long[0]);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context, long[] filterSegmentsEntryIds, long[] segmentsEntryIds) {
        List segmentsEntries = this.segmentsEntryLocalService.getSegmentsEntries(groupId, true, this.getSource(), className, -1, -1, null);
        if (segmentsEntries.isEmpty()) {
            return new long[0];
        }
        return TransformUtil.transformToLongArray((Collection)segmentsEntries, segmentsEntry -> {
            if (!ArrayUtil.isEmpty((long[])filterSegmentsEntryIds) && !ArrayUtil.contains((long[])filterSegmentsEntryIds, (long)segmentsEntry.getSegmentsEntryId()) || !this.isMember(className, classPK, context, (SegmentsEntry)segmentsEntry, segmentsEntryIds)) {
                return null;
            }
            return segmentsEntry.getSegmentsEntryId();
        });
    }

    protected Criteria.Conjunction getConjunction(SegmentsEntry segmentsEntry, Criteria.Type type) {
        Criteria existingCriteria = segmentsEntry.getCriteriaObj();
        if (existingCriteria == null) {
            return Criteria.Conjunction.AND;
        }
        return existingCriteria.getTypeConjunction(type);
    }

    protected String getFilterString(SegmentsEntry segmentsEntry, Criteria.Type type) {
        Criteria existingCriteria = segmentsEntry.getCriteriaObj();
        if (existingCriteria == null) {
            return null;
        }
        Criteria criteria = new Criteria();
        List segmentsCriteriaContributors = this.segmentsCriteriaContributorRegistry.getSegmentsCriteriaContributors(segmentsEntry.getType());
        for (SegmentsCriteriaContributor segmentsCriteriaContributor : segmentsCriteriaContributors) {
            Criteria.Criterion criterion = segmentsCriteriaContributor.getCriterion(existingCriteria);
            if (criterion == null) continue;
            segmentsCriteriaContributor.contribute(criteria, criterion.getFilterString(), Criteria.Conjunction.parse((String)criterion.getConjunction()));
        }
        return criteria.getFilterString(type);
    }

    protected abstract String getSource();

    protected boolean isMember(String className, long classPK, Context context, SegmentsEntry segmentsEntry, long[] segmentsEntryIds) {
        String contextFilterString = this.getFilterString(segmentsEntry, Criteria.Type.CONTEXT);
        if (this.segmentsEntryRelLocalService.hasSegmentsEntryRel(segmentsEntry.getSegmentsEntryId(), this.portal.getClassNameId(className), classPK) && Validator.isNull((String)contextFilterString)) {
            return true;
        }
        Criteria criteria = segmentsEntry.getCriteriaObj();
        if (criteria == null || MapUtil.isEmpty((Map)criteria.getCriteria())) {
            return false;
        }
        Criteria.Conjunction contextConjunction = this.getConjunction(segmentsEntry, Criteria.Type.CONTEXT);
        String modelFilterString = this.getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (context != null) {
            boolean guestUser;
            boolean bl = guestUser = !GetterUtil.getBoolean((Object)context.get((Object)"signedIn"), (boolean)true);
            if (contextConjunction.equals((Object)Criteria.Conjunction.AND) && guestUser && Validator.isNotNull((String)modelFilterString)) {
                return false;
            }
            boolean matchesContext = false;
            if (Validator.isNotNull((String)contextFilterString)) {
                block16: {
                    try {
                        matchesContext = this.oDataMatcher.matches(contextFilterString, (Object)context);
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block16;
                        _log.warn((Throwable)portalException);
                    }
                }
                if (matchesContext && contextConjunction.equals((Object)Criteria.Conjunction.OR)) {
                    return true;
                }
                if (!matchesContext && contextConjunction.equals((Object)Criteria.Conjunction.AND)) {
                    return false;
                }
            }
            if (guestUser) {
                return matchesContext;
            }
        }
        ODataRetriever oDataRetriever = (ODataRetriever)this.serviceTrackerMap.getService((Object)className);
        if (Validator.isNotNull((String)modelFilterString) && oDataRetriever != null) {
            boolean matchesModel = false;
            try {
                int count = oDataRetriever.getResultsCount(segmentsEntry.getCompanyId(), StringBundler.concat((Object[])new Object[]{"(", modelFilterString, ") and (classPK eq '", classPK, "')"}), LocaleUtil.getDefault());
                if (count > 0) {
                    matchesModel = true;
                }
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
            Criteria.Conjunction modelConjunction = this.getConjunction(segmentsEntry, Criteria.Type.MODEL);
            if (matchesModel && modelConjunction.equals((Object)Criteria.Conjunction.OR)) {
                return true;
            }
            if (!matchesModel && modelConjunction.equals((Object)Criteria.Conjunction.AND)) {
                return false;
            }
        }
        return true;
    }
}

