/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.entity;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.normalizer.Normalizer;
import com.liferay.segments.field.Field;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizer;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizerRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={EntityModelFieldMapper.class})
public class EntityModelFieldMapper {
    private static final Log _log = LogFactoryUtil.getLog(EntityModelFieldMapper.class);
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsFieldCustomizerRegistry _segmentsFieldCustomizerRegistry;

    public Map<String, EntityField> getCustomFieldEntityFields(EntityModel entityModel) {
        Map entityFieldsMap = entityModel.getEntityFieldsMap();
        ComplexEntityField customFieldEntityField = (ComplexEntityField)entityFieldsMap.get("customField");
        if (customFieldEntityField == null) {
            return Collections.emptyMap();
        }
        return customFieldEntityField.getEntityFieldsMap();
    }

    public ExpandoColumn getExpandoColumn(String entityFieldName) {
        long expandoColumnId = this.getExpandoColumnId(entityFieldName);
        try {
            return this._expandoColumnLocalService.getColumn(expandoColumnId);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to find Expando Column with id " + expandoColumnId), (Throwable)portalException);
            return null;
        }
    }

    public String getExpandoColumnEntityFieldName(ExpandoColumn expandoColumn) {
        return StringBundler.concat((Object[])new Object[]{"_", expandoColumn.getColumnId(), "_", Normalizer.normalizeIdentifier((String)expandoColumn.getName())});
    }

    public long getExpandoColumnId(String entityFieldName) {
        String[] split = StringUtil.split((String)entityFieldName, (String)"_");
        if (split.length < 2) {
            return 0L;
        }
        return Long.valueOf(split[1]);
    }

    public List<Field> getFields(EntityModel entityModel, PortletRequest portletRequest) {
        Map entityFieldsMap = entityModel.getEntityFieldsMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        entityFieldsMap.forEach((entityFieldName, entityField) -> fields.addAll(this.getFields(entityModel, (EntityField)entityField, portletRequest)));
        Collections.sort(fields);
        return fields;
    }

    protected List<Field> getFields(EntityModel entityModel, EntityField entityField, PortletRequest portletRequest) {
        Locale locale = this._portal.getLocale(portletRequest);
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, this.getClass());
        EntityField.Type entityFieldType = entityField.getType();
        if (entityFieldType == EntityField.Type.COMPLEX) {
            ComplexEntityField complexEntityField = (ComplexEntityField)entityField;
            return this._getComplexFields(entityModel.getName(), entityField.getName(), complexEntityField.getEntityFieldsMap(), locale, portletRequest, resourceBundle);
        }
        SegmentsFieldCustomizer segmentsFieldCustomizer = this._segmentsFieldCustomizerRegistry.getSegmentsFieldCustomizer(entityModel.getName(), entityField.getName());
        if (entityFieldType == EntityField.Type.ID && segmentsFieldCustomizer == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this._getField(entityField.getName(), this._getType(entityField.getType()), portletRequest, resourceBundle, segmentsFieldCustomizer));
    }

    private List<Field> _getComplexFields(String entityModelName, String complexEntityFieldName, Map<String, EntityField> entityFieldsMap, Locale locale, PortletRequest portletRequest, ResourceBundle resourceBundle) {
        if (complexEntityFieldName.equals("customField")) {
            return this._getCustomFields(entityFieldsMap, locale);
        }
        ArrayList<Field> complexFields = new ArrayList<Field>();
        entityFieldsMap.forEach((entityFieldName, entityField) -> {
            SegmentsFieldCustomizer segmentsFieldCustomizer = this._segmentsFieldCustomizerRegistry.getSegmentsFieldCustomizer(entityModelName, entityField.getName());
            if (entityField.getType() == EntityField.Type.ID && segmentsFieldCustomizer == null) {
                return;
            }
            complexFields.add(this._getField("customContext/" + entityField.getName(), this._getType(entityField.getType()), portletRequest, resourceBundle, segmentsFieldCustomizer));
        });
        return complexFields;
    }

    private List<Field> _getCustomFields(Map<String, EntityField> entityFieldsMap, Locale locale) {
        ArrayList<Field> customFields = new ArrayList<Field>();
        entityFieldsMap.forEach((entityFieldName, entityField) -> {
            ExpandoColumn expandoColumn = this._expandoColumnLocalService.fetchExpandoColumn(this.getExpandoColumnId((String)entityFieldName));
            if (expandoColumn == null) {
                return;
            }
            String label = expandoColumn.getDisplayName(locale);
            customFields.add(new Field("customField/" + entityFieldName, label, this._getType(entityField.getType()), this._getExpandoColumnFieldOptions(expandoColumn), null));
        });
        return customFields;
    }

    private List<Field.Option> _getExpandoColumnFieldOptions(ExpandoColumn expandoColumn) {
        ArrayList<Field.Option> fieldOptions;
        block7: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                fieldOptions = new ArrayList<Field.Option>();
                                if (expandoColumn.getType() != 6) break block6;
                                for (double value : (double[])expandoColumn.getDefaultValue()) {
                                    fieldOptions.add(new Field.Option(String.valueOf(value), String.valueOf(value)));
                                }
                                break block7;
                            }
                            if (expandoColumn.getType() != 8) break block8;
                            for (float value : (float[])expandoColumn.getDefaultValue()) {
                                fieldOptions.add(new Field.Option(String.valueOf(value), String.valueOf(value)));
                            }
                            break block7;
                        }
                        if (expandoColumn.getType() != 10) break block9;
                        for (int value : (int[])expandoColumn.getDefaultValue()) {
                            fieldOptions.add(new Field.Option(String.valueOf(value), String.valueOf(value)));
                        }
                        break block7;
                    }
                    if (expandoColumn.getType() != 12) break block10;
                    for (long value : (long[])expandoColumn.getDefaultValue()) {
                        fieldOptions.add(new Field.Option(String.valueOf(value), String.valueOf(value)));
                    }
                    break block7;
                }
                if (expandoColumn.getType() != 14) break block11;
                for (short value : (short[])expandoColumn.getDefaultValue()) {
                    fieldOptions.add(new Field.Option(String.valueOf(value), String.valueOf(value)));
                }
                break block7;
            }
            if (expandoColumn.getType() != 16) break block7;
            for (String value : (String[])expandoColumn.getDefaultValue()) {
                fieldOptions.add(new Field.Option(value, value));
            }
        }
        return fieldOptions;
    }

    private Field _getField(String fieldName, String fieldType, PortletRequest portletRequest, ResourceBundle resourceBundle, SegmentsFieldCustomizer segmentsFieldCustomizer) {
        if (segmentsFieldCustomizer != null) {
            return new Field(fieldName, segmentsFieldCustomizer.getLabel(fieldName, resourceBundle.getLocale()), fieldType, segmentsFieldCustomizer.getOptions(resourceBundle.getLocale()), segmentsFieldCustomizer.getSelectEntity(portletRequest));
        }
        String fieldLabel = this._language.get(resourceBundle, "field." + CamelCaseUtil.fromCamelCase((String)fieldName));
        return new Field(fieldName, fieldLabel, fieldType);
    }

    private String _getType(EntityField.Type entityFieldType) {
        if (entityFieldType == EntityField.Type.BOOLEAN) {
            return "boolean";
        }
        if (entityFieldType == EntityField.Type.COLLECTION) {
            return "collection";
        }
        if (entityFieldType == EntityField.Type.DATE) {
            return "date";
        }
        if (entityFieldType == EntityField.Type.DATE_TIME) {
            return "date-time";
        }
        if (entityFieldType == EntityField.Type.DOUBLE) {
            return "double";
        }
        if (entityFieldType == EntityField.Type.ID) {
            return "id";
        }
        if (entityFieldType == EntityField.Type.INTEGER) {
            return "integer";
        }
        return "string";
    }
}

