/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.criteria.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.field.Field;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import com.liferay.segments.odata.retriever.ODataRetriever;
import java.util.List;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"segments.criteria.contributor.key=user-organization", "segments.criteria.contributor.model.class.name=com.liferay.portal.kernel.model.User", "segments.criteria.contributor.priority:Integer=60"}, service={SegmentsCriteriaContributor.class})
public class UserOrganizationSegmentsCriteriaContributor
implements SegmentsCriteriaContributor {
    public static final String KEY = "user-organization";
    private static final Log _log = LogFactoryUtil.getLog(UserOrganizationSegmentsCriteriaContributor.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=Organization)")
    private volatile EntityModel _entityModel;
    @Reference
    private EntityModelFieldMapper _entityModelFieldMapper;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Organization)")
    private ODataRetriever<Organization> _oDataRetriever;

    public void contribute(Criteria criteria, String filterString, Criteria.Conjunction conjunction) {
        criteria.addCriterion(this.getKey(), this.getType(), filterString, conjunction);
        String newFilterString = null;
        try {
            List organizations = this._oDataRetriever.getResults(CompanyThreadLocal.getCompanyId().longValue(), filterString, LocaleUtil.getDefault(), -1, -1);
            if (!organizations.isEmpty()) {
                StringBundler sb = new StringBundler(2 * organizations.size() + 1);
                sb.append("organizationIds in ('");
                for (Organization organization : organizations) {
                    sb.append(organization.getOrganizationId());
                    sb.append("', '");
                }
                sb.setStringAt("')", sb.index() - 1);
                newFilterString = sb.toString();
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to evaluate criteria ", criteria, " with filter ", filterString, " and conjunction ", conjunction.getValue()}), (Throwable)portalException);
        }
        if (newFilterString == null) {
            newFilterString = "(userId eq '0')";
        }
        criteria.addFilter(this.getType(), newFilterString, conjunction);
    }

    public EntityModel getEntityModel() {
        return this._entityModel;
    }

    public String getEntityName() {
        return "Organization";
    }

    public List<Field> getFields(PortletRequest portletRequest) {
        return this._entityModelFieldMapper.getFields(this._entityModel, portletRequest);
    }

    public String getKey() {
        return KEY;
    }

    public Criteria.Type getType() {
        return Criteria.Type.MODEL;
    }
}

