/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryRoleModel;
import com.liferay.segments.service.SegmentsEntryRoleLocalService;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.segments.model.SegmentsEntry"}, service={ModelDocumentContributor.class})
public class SegmentsEntryModelDocumentContributor
implements ModelDocumentContributor<SegmentsEntry> {
    @Reference
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;
    @Reference
    private SegmentsEntryRoleLocalService _segmentsEntryRoleLocalService;

    public void contribute(Document document, SegmentsEntry segmentsEntry) {
        document.addKeyword("active", segmentsEntry.isActive());
        document.addLocalizedKeyword("description", segmentsEntry.getDescriptionMap(), true);
        document.addDate("modified", segmentsEntry.getModifiedDate());
        this._searchLocalizationHelper.addLocalizedField(document, "name", this._getSiteDefaultLocale(segmentsEntry.getGroupId()), segmentsEntry.getNameMap());
        document.addLocalizedKeyword("localized_name", this._localization.populateLocalizationMap(segmentsEntry.getNameMap(), segmentsEntry.getDefaultLanguageId(), segmentsEntry.getGroupId()), true, true);
        document.addKeyword("roleIds", this._getRoleIds(segmentsEntry.getSegmentsEntryId()));
        document.addKeyword("source", StringUtil.toLowerCase((String)segmentsEntry.getSource()));
    }

    private long[] _getRoleIds(long segmentsEntryId) {
        List segmentsEntryRoles = this._segmentsEntryRoleLocalService.getSegmentsEntryRoles(segmentsEntryId);
        Stream stream = segmentsEntryRoles.stream();
        return stream.mapToLong(SegmentsEntryRoleModel::getRoleId).toArray();
    }

    private Locale _getSiteDefaultLocale(long groupId) {
        try {
            return this._portal.getSiteDefaultLocale(groupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

