/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.matcher;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.segments.context.Context;
import com.liferay.segments.odata.matcher.ODataMatcher;
import java.util.function.Predicate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"target.class.name=com.liferay.segments.context.Context"}, service={ODataMatcher.class})
public class ContextODataMatcher
implements ODataMatcher<Context> {
    private static final Log _log = LogFactoryUtil.getLog(ContextODataMatcher.class);
    private volatile EntityModel _entityModel;
    @Reference(target="(result.class.name=java.util.function.Predicate)")
    private ExpressionConvert<Predicate<Context>> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;

    public boolean matches(String filterString, Context pattern) throws PortalException {
        try {
            Predicate<Context> predicate = this._getPredicate(filterString);
            return predicate.test(pattern);
        }
        catch (Exception exception) {
            throw new PortalException("Unable to match filter: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=Context)", unbind="unbindEntityModel")
    protected void setEntityModel(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + entityModel));
        }
        this._entityModel = entityModel;
    }

    protected void unbindEntityModel(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + entityModel));
        }
        this._entityModel = null;
    }

    private Predicate<Context> _getPredicate(String filterString) throws Exception {
        FilterParser filterParser = this._filterParserProvider.provide(this._entityModel);
        Filter filter = new Filter(filterParser.parse(filterString));
        try {
            return (Predicate)this._expressionConvert.convert(filter.getExpression(), LocaleUtil.getDefault(), this._entityModel);
        }
        catch (Exception exception) {
            throw new InvalidFilterException("Invalid filter: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

