/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.model.listener;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnTable;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoTableTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.portal.odata.normalizer.Normalizer;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.segments.internal.odata.entity.OrganizationEntityModel;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class OrganizationExpandoColumnModelListener
extends BaseModelListener<ExpandoColumn> {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationExpandoColumnModelListener.class);
    private BundleContext _bundleContext;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private Map<Long, EntityField> _entityFieldsMap = new HashMap<Long, EntityField>();
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    private ServiceRegistration<EntityModel> _serviceRegistration;

    public void onAfterCreate(ExpandoColumn expandoColumn) throws ModelListenerException {
        try {
            long classNameId = this._classNameLocalService.getClassNameId(Organization.class.getName());
            ExpandoTable expandoTable = this._expandoTableLocalService.getTable(expandoColumn.getTableId());
            if (classNameId != expandoTable.getClassNameId() || !"CUSTOM_FIELDS".equals(expandoTable.getName())) {
                return;
            }
            EntityField entityField = this._getEntityField(expandoColumn);
            if (entityField != null) {
                this._entityFieldsMap.put(expandoColumn.getColumnId(), entityField);
                this._serviceRegistration.unregister();
                this._serviceRegistration = this._register();
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterRemove(ExpandoColumn expandoColumn) throws ModelListenerException {
        if (expandoColumn == null) {
            return;
        }
        if (this._entityFieldsMap.containsKey(expandoColumn.getColumnId())) {
            this._entityFieldsMap.remove(expandoColumn.getColumnId());
            this._serviceRegistration.unregister();
            this._serviceRegistration = this._register();
        }
    }

    public void onAfterUpdate(ExpandoColumn originalExpandoColumn, ExpandoColumn expandoColumn) throws ModelListenerException {
        if (expandoColumn == null) {
            return;
        }
        this._entityFieldsMap.remove(expandoColumn.getColumnId());
        this.onAfterCreate(expandoColumn);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        try {
            this._bundleContext = bundleContext;
            this._entityFieldsMap = this._getEntityFieldsMap();
            this._serviceRegistration = this._register();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private String _encodeName(ExpandoColumn expandoColumn) {
        return StringBundler.concat((Object[])new Object[]{"_", expandoColumn.getColumnId(), "_", Normalizer.normalizeIdentifier((String)expandoColumn.getName())});
    }

    private EntityField _getEntityField(ExpandoColumn expandoColumn) {
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        int indexType = GetterUtil.getInteger((String)((String)unicodeProperties.get((Object)"index-type")));
        if (indexType == 0) {
            return null;
        }
        Object entityField = null;
        String encodedName = this._encodeName(expandoColumn);
        String encodedIndexedFieldName = this._expandoBridgeIndexer.encodeFieldName(expandoColumn);
        entityField = expandoColumn.getType() == 1 ? new BooleanEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 3 ? new DateTimeEntityField(encodedName, locale -> Field.getSortableFieldName((String)encodedIndexedFieldName), locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 5 || expandoColumn.getType() == 6 || expandoColumn.getType() == 7 || expandoColumn.getType() == 8 ? new DoubleEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 9 || expandoColumn.getType() == 10 || expandoColumn.getType() == 11 || expandoColumn.getType() == 12 || expandoColumn.getType() == 13 || expandoColumn.getType() == 14 ? new IntegerEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 20 ? new StringEntityField(encodedName, locale -> Field.getLocalizedName((Locale)locale, (String)encodedIndexedFieldName)) : new StringEntityField(encodedName, locale -> encodedIndexedFieldName)))));
        return entityField;
    }

    private Map<Long, EntityField> _getEntityFieldsMap() throws PortalException {
        HashMap<Long, EntityField> entityFieldsMap = new HashMap<Long, EntityField>();
        long classNameId = this._classNameLocalService.getClassNameId(Organization.class.getName());
        List expandoColumns = (List)this._expandoColumnLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)ExpandoColumnTable.INSTANCE).from((Table)ExpandoColumnTable.INSTANCE).where(ExpandoColumnTable.INSTANCE.tableId.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{ExpandoTableTable.INSTANCE.tableId}).from((Table)ExpandoTableTable.INSTANCE).where(ExpandoTableTable.INSTANCE.classNameId.eq((Object)classNameId).and((Expression)ExpandoTableTable.INSTANCE.name.eq((Object)"CUSTOM_FIELDS"))))));
        for (ExpandoColumn expandoColumn : expandoColumns) {
            EntityField entityField = this._getEntityField(expandoColumn);
            if (entityField == null) continue;
            entityFieldsMap.put(expandoColumn.getColumnId(), entityField);
        }
        return entityFieldsMap;
    }

    private ServiceRegistration<EntityModel> _register() {
        return this._bundleContext.registerService(EntityModel.class, (Object)new OrganizationEntityModel(new ArrayList<EntityField>(this._entityFieldsMap.values())), (Dictionary)HashMapDictionaryBuilder.put((Object)"entity.model.name", (Object)"Organization").build());
    }
}

