/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.messaging;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={})
public class SegmentsEntryRelIndexerMessageListener
extends BaseMessageListener {
    @Reference
    private MessageBus _messageBus;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    private volatile SegmentsConfiguration _segmentsConfiguration;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._segmentsConfiguration.segmentsPreviewCheckInterval(), TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._segmentsEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property activeProperty = PropertyFactoryUtil.forName((String)"active");
            dynamicQuery.add(activeProperty.eq((Object)true));
        });
        actionableDynamicQuery.setPerformActionMethod(this::_reindex);
        actionableDynamicQuery.performActions();
    }

    private void _reindex(SegmentsEntry segmentsEntry) {
        Message message = new Message();
        message.put("companyId", (Object)segmentsEntry.getCompanyId());
        message.put("segmentsEntryId", (Object)segmentsEntry.getSegmentsEntryId());
        message.put("type", (Object)segmentsEntry.getType());
        this._messageBus.sendMessage("liferay/segments_entry_reindex", message);
    }
}

