/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.messaging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/segments_entry_reindex"}, service={MessageListener.class})
public class SegmentsEntryReindexMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryReindexMessageListener.class);
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;

    protected void doReceive(Message message) {
        block5: {
            String type = message.getString("type");
            Indexer indexer = this._indexerRegistry.getIndexer(type);
            if (indexer == null) {
                return;
            }
            long segmentsEntryId = message.getLong("segmentsEntryId");
            if (segmentsEntryId == 0L) {
                return;
            }
            long companyId = message.getLong("companyId");
            try {
                Set classPKs = SetUtil.symmetricDifference(this._getOldClassPKs(companyId, segmentsEntryId, (Indexer<Object>)indexer), this._getNewClassPKs(segmentsEntryId));
                Iterator iterator = classPKs.iterator();
                while (iterator.hasNext()) {
                    long classPK = (Long)iterator.next();
                    indexer.reindex(type, classPK);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to index segment members", (Throwable)portalException);
            }
        }
    }

    private Set<Long> _getNewClassPKs(long segmentsEntryId) throws PortalException {
        long[] classPKs = this._segmentsEntryProviderRegistry.getSegmentsEntryClassPKs(segmentsEntryId, -1, -1);
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry != null && segmentsEntry.getCriteriaObj() != null) {
            this._segmentsEntryRelLocalService.deleteSegmentsEntryRels(segmentsEntryId);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setScopeGroupId(segmentsEntry.getGroupId());
            serviceContext.setUserId(segmentsEntry.getUserId());
            this._segmentsEntryRelLocalService.addSegmentsEntryRels(segmentsEntryId, this._portal.getClassNameId(segmentsEntry.getType()), classPKs, serviceContext);
        }
        return SetUtil.fromArray((long[])classPKs);
    }

    private Set<Long> _getOldClassPKs(long companyId, long segmentsEntryId, Indexer<Object> indexer) throws SearchException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("segmentsEntryIds", (Serializable)new long[]{segmentsEntryId});
        searchContext.setCompanyId(companyId);
        Hits hits = indexer.search(searchContext);
        HashSet<Long> classPKsSet = new HashSet<Long>();
        for (Document document : hits.getDocs()) {
            classPKsSet.add(GetterUtil.getLong((String)document.get("entryClassPK")));
        }
        return classPKsSet;
    }
}

