/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.configuration.provider;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.configuration.SegmentsCompanyConfiguration;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.configuration.provider.SegmentsConfigurationProvider;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={SegmentsConfigurationProvider.class})
public class SegmentsConfigurationProviderImpl
implements SegmentsConfigurationProvider {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;
    private volatile SegmentsConfiguration _segmentsConfiguration;

    public String getCompanyConfigurationURL(HttpServletRequest httpServletRequest) throws PortalException {
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(this._portal.getUser(httpServletRequest));
        if (permissionChecker.isCompanyAdmin()) {
            String factoryPid;
            String pid = factoryPid = SegmentsCompanyConfiguration.class.getName();
            Configuration configuration = this._getSegmentsCompanyConfiguration(this._portal.getCompanyId(httpServletRequest));
            if (configuration != null) {
                pid = configuration.getPid();
            }
            return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, "com_liferay_configuration_admin_web_portlet_InstanceSettingsPortlet", "RENDER_PHASE")).setMVCRenderCommandName("/configuration_admin/edit_configuration").setRedirect(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL", (String)this._portal.getCurrentCompleteURL(httpServletRequest))).setParameter("factoryPid", factoryPid).setParameter("pid", pid).buildString();
        }
        return null;
    }

    public String getConfigurationURL(HttpServletRequest httpServletRequest) throws PortalException {
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(this._portal.getUser(httpServletRequest));
        if (!permissionChecker.isOmniadmin()) {
            return null;
        }
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, "com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", "RENDER_PHASE")).setMVCRenderCommandName("/configuration_admin/edit_configuration").setRedirect(this._portal.getCurrentCompleteURL(httpServletRequest)).setParameter("factoryPid", SegmentsConfiguration.class.getName()).buildString();
    }

    public boolean isRoleSegmentationEnabled() throws ConfigurationException {
        return this._segmentsConfiguration.roleSegmentationEnabled();
    }

    public boolean isRoleSegmentationEnabled(long companyId) throws ConfigurationException {
        if (!this._segmentsConfiguration.roleSegmentationEnabled()) {
            return false;
        }
        if (!this.isSegmentsCompanyConfigurationDefined(companyId)) {
            return this._segmentsConfiguration.roleSegmentationEnabled();
        }
        SegmentsCompanyConfiguration segmentsCompanyConfiguration = (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId);
        return segmentsCompanyConfiguration.roleSegmentationEnabled();
    }

    public boolean isSegmentationEnabled() throws ConfigurationException {
        return this._segmentsConfiguration.segmentationEnabled();
    }

    public boolean isSegmentationEnabled(long companyId) throws ConfigurationException {
        if (!this._segmentsConfiguration.segmentationEnabled()) {
            return false;
        }
        if (!this.isSegmentsCompanyConfigurationDefined(companyId)) {
            return this._segmentsConfiguration.segmentationEnabled();
        }
        SegmentsCompanyConfiguration segmentsCompanyConfiguration = (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId);
        return segmentsCompanyConfiguration.segmentationEnabled();
    }

    public boolean isSegmentsCompanyConfigurationDefined(long companyId) throws ConfigurationException {
        return this._getSegmentsCompanyConfiguration(companyId) != null;
    }

    public void resetSegmentsCompanyConfiguration(long companyId) throws ConfigurationException {
        Configuration configuration = this._getSegmentsCompanyConfiguration(companyId);
        while (configuration != null) {
            try {
                configuration.delete();
            }
            catch (IOException ioException) {
                throw new ConfigurationException((Throwable)ioException);
            }
            configuration = this._getSegmentsCompanyConfiguration(companyId);
        }
    }

    public void updateSegmentsCompanyConfiguration(long companyId, SegmentsCompanyConfiguration segmentsCompanyConfiguration) throws ConfigurationException {
        Dictionary properties = null;
        Configuration configuration = this._getSegmentsCompanyConfiguration(companyId);
        if (configuration == null) {
            try {
                configuration = this._configurationAdmin.createFactoryConfiguration(SegmentsCompanyConfiguration.class.getName() + ".scoped", "?");
            }
            catch (IOException ioException) {
                throw new ConfigurationException((Throwable)ioException);
            }
            properties = HashMapDictionaryBuilder.put((Object)ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey(), (Object)companyId).build();
        } else {
            properties = configuration.getProperties();
        }
        properties.put("roleSegmentationEnabled", segmentsCompanyConfiguration.roleSegmentationEnabled());
        properties.put("segmentationEnabled", segmentsCompanyConfiguration.segmentationEnabled());
        try {
            configuration.update(properties);
        }
        catch (IOException ioException) {
            throw new ConfigurationException((Throwable)ioException);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
    }

    private Configuration _getSegmentsCompanyConfiguration(long companyId) throws ConfigurationException {
        try {
            String filterString = StringBundler.concat((Object[])new Object[]{"(&(", "service.factoryPid", "=", SegmentsCompanyConfiguration.class.getName(), ".scoped", ")(companyId=", companyId, "))"});
            Configuration[] configuration = this._configurationAdmin.listConfigurations(filterString);
            if (configuration != null) {
                return configuration[0];
            }
            return null;
        }
        catch (IOException | InvalidSyntaxException exception) {
            throw new ConfigurationException(exception);
        }
    }
}

