/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.configuration.provider.SegmentsConfigurationProvider;
import com.liferay.segments.context.Context;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.simulator.SegmentsEntrySimulator;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SegmentsEntryRetriever.class})
public class SegmentsEntryRetrieverImpl
implements SegmentsEntryRetriever {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryRetrieverImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsConfigurationProvider _segmentsConfigurationProvider;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private volatile SegmentsEntrySimulator _segmentsEntrySimulator;

    public long[] getSegmentsEntryIds(long groupId, long userId, Context context, long[] segmentEntryIds) {
        try {
            if (!this._segmentsConfigurationProvider.isSegmentationEnabled(this._getCompanyId(groupId))) {
                return new long[]{0L};
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return ArrayUtil.toLongArray((Collection)SetUtil.fromArray((long[])ArrayUtil.append((long[])this._getSegmentEntryIds(groupId, userId, context, segmentEntryIds), (long)0L)));
    }

    private long _getCompanyId(long groupId) throws PortalException {
        if (groupId == 0L) {
            return this._portal.getDefaultCompanyId();
        }
        Group group = this._groupLocalService.getGroup(groupId);
        return group.getCompanyId();
    }

    private long[] _getSegmentEntryIds(long groupId, long userId, Context context, long[] segmentEntryIds) {
        if (this._segmentsEntrySimulator != null && this._segmentsEntrySimulator.isSimulationActive(userId)) {
            return this._segmentsEntrySimulator.getSimulatedSegmentsEntryIds(userId);
        }
        try {
            return this._segmentsEntryProviderRegistry.getSegmentsEntryIds(groupId, User.class.getName(), userId, context, segmentEntryIds);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return new long[0];
        }
    }
}

