/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.internal.odata.filter.expression;

import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;

import java.util.Locale;
import java.util.function.Predicate;

import org.osgi.service.component.annotations.Component;

/**
 * @author Cristina González
 */
@Component(
	property = "result.class.name=java.util.function.Predicate",
	service = ExpressionConvert.class
)
public class PredicateExpressionConvertImpl
	implements ExpressionConvert<Predicate<?>> {

	@Override
	public Predicate<?> convert(
			Expression expression, Locale locale, EntityModel entityModel)
		throws ExpressionVisitException {

		return (Predicate<?>)expression.accept(
			new PredicateExpressionVisitorImpl(entityModel));
	}

}