/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.segments.constants.SegmentsExperimentConstants;
import com.liferay.segments.exception.LockedSegmentsExperimentException;
import com.liferay.segments.exception.SegmentsExperimentRelNameException;
import com.liferay.segments.exception.SegmentsExperimentRelSplitException;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.SegmentsExperimentRel;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.base.SegmentsExperimentRelLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsExperimentRel"}, service={AopService.class})
public class SegmentsExperimentRelLocalServiceImpl
extends SegmentsExperimentRelLocalServiceBaseImpl {
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public SegmentsExperimentRel addSegmentsExperimentRel(long segmentsExperimentId, long segmentsExperienceId, ServiceContext serviceContext) throws PortalException {
        this._validateSegmentsExperimentStatus(segmentsExperimentId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long segmentsExperimentRelId = this.counterLocalService.increment();
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelPersistence.create(segmentsExperimentRelId);
        segmentsExperimentRel.setGroupId(serviceContext.getScopeGroupId());
        segmentsExperimentRel.setCompanyId(user.getCompanyId());
        segmentsExperimentRel.setUserId(user.getUserId());
        segmentsExperimentRel.setUserName(user.getFullName());
        segmentsExperimentRel.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsExperimentRel.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsExperimentRel.setSegmentsExperimentId(segmentsExperimentId);
        segmentsExperimentRel.setSegmentsExperienceId(segmentsExperienceId);
        return (SegmentsExperimentRel)this.segmentsExperimentRelPersistence.update((BaseModel)segmentsExperimentRel);
    }

    @Override
    public SegmentsExperimentRel deleteSegmentsExperimentRel(long segmentsExperimentRelId) throws PortalException {
        return this.segmentsExperimentRelLocalService.deleteSegmentsExperimentRel(this.segmentsExperimentRelPersistence.findByPrimaryKey(segmentsExperimentRelId));
    }

    @Override
    public SegmentsExperimentRel deleteSegmentsExperimentRel(SegmentsExperimentRel segmentsExperimentRel) throws PortalException {
        return this.segmentsExperimentRelLocalService.deleteSegmentsExperimentRel(segmentsExperimentRel, false);
    }

    @SystemEvent(type=1)
    public SegmentsExperimentRel deleteSegmentsExperimentRel(SegmentsExperimentRel segmentsExperimentRel, boolean force) throws PortalException {
        if (!force) {
            this._validateSegmentsExperimentStatus(segmentsExperimentRel.getSegmentsExperimentId());
        }
        this.segmentsExperimentRelPersistence.remove((BaseModel)segmentsExperimentRel);
        if (!segmentsExperimentRel.isActive()) {
            this._segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperimentRel.getSegmentsExperienceId());
        }
        return segmentsExperimentRel;
    }

    public void deleteSegmentsExperimentRels(long segmentsExperimentId) throws PortalException {
        List segmentsExperimentRels = this.segmentsExperimentRelPersistence.findBySegmentsExperimentId(segmentsExperimentId);
        for (SegmentsExperimentRel segmentsExperimentRel : segmentsExperimentRels) {
            this.segmentsExperimentRelLocalService.deleteSegmentsExperimentRel(segmentsExperimentRel, true);
        }
    }

    public SegmentsExperimentRel fetchSegmentsExperimentRel(long segmentsExperimentId, long segmentsExperienceId) throws PortalException {
        return this.segmentsExperimentRelPersistence.fetchByS_S(segmentsExperimentId, segmentsExperienceId);
    }

    public SegmentsExperimentRel getSegmentsExperimentRel(long segmentsExperimentId, long segmentsExperienceId) throws PortalException {
        return this.segmentsExperimentRelPersistence.findByS_S(segmentsExperimentId, segmentsExperienceId);
    }

    public List<SegmentsExperimentRel> getSegmentsExperimentRels(long segmentsExperimentId) {
        return this.segmentsExperimentRelPersistence.findBySegmentsExperimentId(segmentsExperimentId);
    }

    public SegmentsExperimentRel updateSegmentsExperimentRel(long segmentsExperimentRelId, double split) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelPersistence.findByPrimaryKey(segmentsExperimentRelId);
        return this._updateSegmentsExperimentRelSplit(segmentsExperimentRel, split);
    }

    public SegmentsExperimentRel updateSegmentsExperimentRel(long segmentsExperimentId, long segmentsExperienceId, double split) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelPersistence.findByS_S(segmentsExperimentId, segmentsExperienceId);
        return this._updateSegmentsExperimentRelSplit(segmentsExperimentRel, split);
    }

    public SegmentsExperimentRel updateSegmentsExperimentRel(long segmentsExperimentRelId, String name, ServiceContext serviceContext) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelPersistence.findByPrimaryKey(segmentsExperimentRelId);
        this._validateSegmentsExperimentStatus(segmentsExperimentRel.getSegmentsExperimentId());
        if (segmentsExperimentRel.isControl()) {
            throw new SegmentsExperimentRelNameException("The experiment control experience cannot be updated");
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.getSegmentsExperience(segmentsExperimentRel.getSegmentsExperienceId());
        segmentsExperience.setName(name, serviceContext.getLocale());
        this._segmentsExperienceLocalService.updateSegmentsExperience(segmentsExperience);
        return (SegmentsExperimentRel)this.segmentsExperimentRelPersistence.update((BaseModel)segmentsExperimentRel);
    }

    private SegmentsExperimentRel _updateSegmentsExperimentRelSplit(SegmentsExperimentRel segmentsExperimentRel, double split) throws PortalException {
        this._validateSegmentsExperimentRelSplit(split);
        segmentsExperimentRel.setSplit(split);
        return (SegmentsExperimentRel)this.segmentsExperimentRelPersistence.update((BaseModel)segmentsExperimentRel);
    }

    private void _validateSegmentsExperimentRelSplit(double split) throws PortalException {
        if (split > 1.0 || split < 0.0) {
            throw new SegmentsExperimentRelSplitException("Split " + split + " is not a value between 0 and 1");
        }
    }

    private void _validateSegmentsExperimentStatus(long segmentsExperimentId) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentPersistence.findByPrimaryKey(segmentsExperimentId);
        SegmentsExperimentConstants.Status status = SegmentsExperimentConstants.Status.valueOf((int)segmentsExperiment.getStatus());
        if (!status.isEditable()) {
            throw new LockedSegmentsExperimentException(segmentsExperimentId);
        }
    }
}

