/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.internal.change.tracking.spi.reference;

import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.segments.model.SegmentsEntryRelTable;
import com.liferay.segments.model.SegmentsEntryTable;
import com.liferay.segments.service.persistence.SegmentsEntryRelPersistence;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(service = TableReferenceDefinition.class)
public class SegmentsEntryRelTableReferenceDefinition
	implements TableReferenceDefinition<SegmentsEntryRelTable> {

	@Override
	public void defineChildTableReferences(
		ChildTableReferenceInfoBuilder<SegmentsEntryRelTable>
			childTableReferenceInfoBuilder) {
	}

	@Override
	public void defineParentTableReferences(
		ParentTableReferenceInfoBuilder<SegmentsEntryRelTable>
			parentTableReferenceInfoBuilder) {

		parentTableReferenceInfoBuilder.groupedModel(
			SegmentsEntryRelTable.INSTANCE
		).singleColumnReference(
			SegmentsEntryRelTable.INSTANCE.segmentsEntryId,
			SegmentsEntryTable.INSTANCE.segmentsEntryId
		).classNameReference(
			SegmentsEntryRelTable.INSTANCE.classPK, UserTable.INSTANCE.userId,
			User.class
		);
	}

	@Override
	public BasePersistence<?> getBasePersistence() {
		return _segmentsEntryRelPersistence;
	}

	@Override
	public SegmentsEntryRelTable getTable() {
		return SegmentsEntryRelTable.INSTANCE;
	}

	@Reference
	private SegmentsEntryRelPersistence _segmentsEntryRelPersistence;

}