/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.exception.LockedSegmentsExperimentException;
import com.liferay.segments.exception.RequiredSegmentsExperienceException;
import com.liferay.segments.exception.SegmentsExperienceNameException;
import com.liferay.segments.exception.SegmentsExperiencePriorityException;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.service.base.SegmentsExperienceLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsExperience"}, service={AopService.class})
public class SegmentsExperienceLocalServiceImpl
extends SegmentsExperienceLocalServiceBaseImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;

    public SegmentsExperience addDefaultSegmentsExperience(long userId, long plid, ServiceContext serviceContext) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(plid);
        return this.addSegmentsExperience(userId, layout.getGroupId(), 0L, "DEFAULT", this.classNameLocalService.getClassNameId(Layout.class), layout.getPlid(), Collections.singletonMap(LocaleUtil.getSiteDefault(), LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)"default-experience-name")), 0, true, new UnicodeProperties(true), serviceContext);
    }

    public SegmentsExperience addSegmentsExperience(long userId, long groupId, long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        int lowestPriority = this._getLowestPriority(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
        return this.addSegmentsExperience(userId, groupId, segmentsEntryId, classNameId, classPK, nameMap, lowestPriority - 1, active, typeSettingsUnicodeProperties, serviceContext);
    }

    public SegmentsExperience addSegmentsExperience(long userId, long groupId, long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, int priority, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        return this.addSegmentsExperience(userId, groupId, segmentsEntryId, String.valueOf(this.counterLocalService.increment()), classNameId, classPK, nameMap, priority, active, typeSettingsUnicodeProperties, serviceContext);
    }

    public SegmentsExperience addSegmentsExperience(long userId, long groupId, long segmentsEntryId, String segmentsExperienceKey, long classNameId, long classPK, Map<Locale, String> nameMap, int priority, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long publishedClassPK = this._getPublishedLayoutClassPK(classPK);
        this._validateName(nameMap);
        this._validatePriority(groupId, classNameId, publishedClassPK, priority);
        long segmentsExperienceId = this.counterLocalService.increment();
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.create(segmentsExperienceId);
        segmentsExperience.setUuid(serviceContext.getUuid());
        segmentsExperience.setGroupId(groupId);
        segmentsExperience.setCompanyId(user.getCompanyId());
        segmentsExperience.setUserId(user.getUserId());
        segmentsExperience.setUserName(user.getFullName());
        segmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsExperience.setSegmentsEntryId(segmentsEntryId);
        segmentsExperience.setSegmentsExperienceKey(segmentsExperienceKey);
        segmentsExperience.setClassNameId(classNameId);
        segmentsExperience.setClassPK(publishedClassPK);
        segmentsExperience.setNameMap(nameMap);
        segmentsExperience.setPriority(priority);
        segmentsExperience.setActive(active);
        segmentsExperience.setTypeSettingsUnicodeProperties(typeSettingsUnicodeProperties);
        segmentsExperience = (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        this.resourceLocalService.addModelResources((AuditedModel)segmentsExperience, serviceContext);
        return segmentsExperience;
    }

    public SegmentsExperience appendSegmentsExperience(long userId, long groupId, long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.appendSegmentsExperience(userId, groupId, segmentsEntryId, classNameId, classPK, nameMap, active, new UnicodeProperties(true), serviceContext);
    }

    public SegmentsExperience appendSegmentsExperience(long userId, long groupId, long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        int highestPriority = this._getHighestPriority(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
        return this.addSegmentsExperience(userId, groupId, segmentsEntryId, classNameId, classPK, nameMap, highestPriority + 1, active, typeSettingsUnicodeProperties, serviceContext);
    }

    public void deleteSegmentsEntrySegmentsExperiences(long segmentsEntryId) throws PortalException {
        List segmentsExperiences = this.segmentsExperiencePersistence.findBySegmentsEntryId(segmentsEntryId);
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
        }
    }

    @Override
    public SegmentsExperience deleteSegmentsExperience(long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        return this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
    }

    @Override
    @SystemEvent(type=1)
    public SegmentsExperience deleteSegmentsExperience(SegmentsExperience segmentsExperience) throws PortalException {
        if (!GroupThreadLocal.isDeleteInProcess() && segmentsExperience.hasSegmentsExperiment()) {
            throw new RequiredSegmentsExperienceException.MustNotDeleteSegmentsExperienceReferencedBySegmentsExperiments(segmentsExperience.getSegmentsExperienceId());
        }
        this.segmentsExperiencePersistence.remove((BaseModel)segmentsExperience);
        this.segmentsExperiencePersistence.flush();
        if (!GroupThreadLocal.isDeleteInProcess()) {
            this._compactSegmentsExperiencesPriorities(segmentsExperience);
        }
        for (SegmentsExperiment segmentsExperiment : this.segmentsExperimentPersistence.findByS_C_C(segmentsExperience.getSegmentsExperienceId(), segmentsExperience.getClassNameId(), this._getPublishedLayoutClassPK(segmentsExperience.getClassPK()))) {
            this._deleteSegmentsExperiment(segmentsExperiment);
        }
        this.resourceLocalService.deleteResource((AuditedModel)segmentsExperience, 4);
        return segmentsExperience;
    }

    public void deleteSegmentsExperiences(long groupId, long classNameId, long classPK) throws PortalException {
        SegmentsExperience defaultSegmentsExperience = this.fetchSegmentsExperience(groupId, "DEFAULT", this.classNameLocalService.getClassNameId(Layout.class), classPK);
        if (defaultSegmentsExperience != null) {
            for (SegmentsExperiment segmentsExperiment : this.segmentsExperimentPersistence.findByS_C_C(defaultSegmentsExperience.getSegmentsExperienceId(), classNameId, this._getPublishedLayoutClassPK(classPK))) {
                this._deleteSegmentsExperiment(segmentsExperiment);
            }
        }
        List segmentsExperiences = this.segmentsExperiencePersistence.findByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
        }
    }

    public long fetchDefaultSegmentsExperienceId(long plid) {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return 0L;
        }
        SegmentsExperience segmentsExperience = this.fetchSegmentsExperience(layout.getGroupId(), "DEFAULT", this.classNameLocalService.getClassNameId(Layout.class), plid);
        if (segmentsExperience == null) {
            return 0L;
        }
        return segmentsExperience.getSegmentsExperienceId();
    }

    @Override
    public SegmentsExperience fetchSegmentsExperience(long segmentsExperienceId) {
        return this.segmentsExperiencePersistence.fetchByPrimaryKey(segmentsExperienceId);
    }

    public SegmentsExperience fetchSegmentsExperience(long groupId, long classNameId, long classPK, int priority) {
        return this.segmentsExperiencePersistence.fetchByG_C_C_P(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), priority);
    }

    public SegmentsExperience fetchSegmentsExperience(long groupId, String segmentsExperienceKey, long classNameId, long classPK) {
        return this.segmentsExperiencePersistence.fetchByG_SEK_C_C(groupId, segmentsExperienceKey, classNameId, this._getPublishedLayoutClassPK(classPK));
    }

    @Override
    public SegmentsExperience getSegmentsExperience(long segmentsExperienceId) throws PortalException {
        return this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
    }

    public SegmentsExperience getSegmentsExperience(long groupId, String segmentsExperienceKey, long classNameId, long classPK) throws PortalException {
        return this.segmentsExperiencePersistence.findByG_SEK_C_C(groupId, segmentsExperienceKey, classNameId, this._getPublishedLayoutClassPK(classPK));
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK) {
        return this.segmentsExperiencePersistence.findByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active) throws PortalException {
        return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) {
        return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active, start, end, orderByComparator);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long[] segmentsEntryIds, long classNameId, long classPK, boolean active) {
        return this.segmentsExperiencePersistence.findByG_S_C_C_A(groupId, segmentsEntryIds, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long[] segmentsEntryIds, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) {
        return this.segmentsExperiencePersistence.findByG_S_C_C_A(groupId, segmentsEntryIds, classNameId, this._getPublishedLayoutClassPK(classPK), active, start, end, orderByComparator);
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK) {
        return this.segmentsExperiencePersistence.countByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK, boolean active) {
        return this.segmentsExperiencePersistence.countByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        return this.updateSegmentsExperience(segmentsExperienceId, segmentsEntryId, nameMap, active, segmentsExperience.getTypeSettingsUnicodeProperties());
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties) throws PortalException {
        this._validateName(nameMap);
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        if (segmentsExperience.hasSegmentsExperiment()) {
            throw new LockedSegmentsExperimentException("Segments experience " + segmentsExperienceId + " has a locked segments experiment");
        }
        segmentsExperience.setSegmentsEntryId(segmentsEntryId);
        segmentsExperience.setNameMap(nameMap);
        segmentsExperience.setActive(active);
        segmentsExperience.setTypeSettingsUnicodeProperties(typeSettingsUnicodeProperties);
        return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
    }

    public SegmentsExperience updateSegmentsExperienceActive(long segmentsExperienceId, boolean active) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        segmentsExperience.setActive(active);
        return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
    }

    public SegmentsExperience updateSegmentsExperiencePriority(long segmentsExperienceId, int newPriority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        if (segmentsExperience.hasSegmentsExperiment()) {
            throw new LockedSegmentsExperimentException("Segments experience " + segmentsExperienceId + " has a locked segments experiment");
        }
        boolean swap = true;
        if (newPriority == 0 && segmentsExperience.getPriority() > 0) {
            newPriority = -1;
            swap = false;
        } else if (newPriority == 0 && segmentsExperience.getPriority() < 0) {
            newPriority = 1;
            swap = false;
        }
        SegmentsExperience swapSegmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), newPriority);
        if (swapSegmentsExperience == null) {
            this._updateSegmentsExperiencePriorityAndFlush(newPriority, segmentsExperience);
            this._compactSegmentsExperiencesPriorities(segmentsExperience);
            return this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperience.getSegmentsExperienceId());
        }
        int oldPriority = segmentsExperience.getPriority();
        this._releaseSegmentExperiencesPriority(newPriority, segmentsExperience, swapSegmentsExperience);
        this._updateSegmentsExperiencePriorityAndFlush(newPriority, this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperience.getSegmentsExperienceId()));
        if (swap) {
            this._updateSegmentsExperiencePriorityAndFlush(oldPriority, this.segmentsExperiencePersistence.findByPrimaryKey(swapSegmentsExperience.getSegmentsExperienceId()));
        }
        this._compactSegmentsExperiencesPriorities(segmentsExperience);
        return this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperience.getSegmentsExperienceId());
    }

    private void _compactSegmentsExperiencesPriorities(SegmentsExperience segmentsExperience) {
        SegmentsExperience curSegmentsExperience;
        ArrayList segmentsExperiences = new ArrayList(this.segmentsExperiencePersistence.findByG_C_C_GtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), 0));
        int updatedPriority = 1;
        int i = segmentsExperiences.size();
        while (i > 0) {
            curSegmentsExperience = (SegmentsExperience)segmentsExperiences.get(i - 1);
            if (curSegmentsExperience.getPriority() != updatedPriority) {
                this._updateSegmentsExperiencePriorityAndFlush(updatedPriority, curSegmentsExperience);
            }
            --i;
            ++updatedPriority;
        }
        segmentsExperiences = new ArrayList(this.segmentsExperiencePersistence.findByG_C_C_LtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), 0));
        updatedPriority = -1;
        i = 0;
        while (i < segmentsExperiences.size()) {
            curSegmentsExperience = (SegmentsExperience)segmentsExperiences.get(i);
            if (curSegmentsExperience.getPriority() != updatedPriority) {
                this._updateSegmentsExperiencePriorityAndFlush(updatedPriority, curSegmentsExperience);
            }
            ++i;
            --updatedPriority;
        }
    }

    private void _deleteSegmentsExperiment(SegmentsExperiment segmentsExperiment) throws PortalException {
        this.segmentsExperimentPersistence.remove((BaseModel)segmentsExperiment);
        this.resourceLocalService.deleteResource((AuditedModel)segmentsExperiment, 4);
        this.segmentsExperimentRelPersistence.removeBySegmentsExperimentId(segmentsExperiment.getSegmentsExperimentId());
    }

    private int _getHighestPriority(long groupId, long classNameId, long classPK) {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_First(groupId, classNameId, classPK, null);
        if (segmentsExperience == null) {
            return 0;
        }
        return segmentsExperience.getPriority();
    }

    private int _getLowestPriority(long groupId, long classNameId, long classPK) {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_Last(groupId, classNameId, classPK, null);
        if (segmentsExperience == null) {
            return 0;
        }
        return segmentsExperience.getPriority();
    }

    private long _getPublishedLayoutClassPK(long classPK) {
        Layout layout = this._layoutLocalService.fetchLayout(classPK);
        if (layout != null && layout.isDraftLayout()) {
            return layout.getClassPK();
        }
        return classPK;
    }

    private void _releaseSegmentExperiencesPriority(int priority, SegmentsExperience segmentsExperience, SegmentsExperience swapSegmentsExperience) {
        if (priority > 0) {
            ArrayList<SegmentsExperience> segmentsExperiences = new ArrayList<SegmentsExperience>(this.segmentsExperiencePersistence.findByG_C_C_GtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), priority));
            segmentsExperiences.add(swapSegmentsExperience);
            for (SegmentsExperience curSegmentsExperience : segmentsExperiences) {
                this._updateSegmentsExperiencePriorityAndFlush(curSegmentsExperience.getPriority() + 1, curSegmentsExperience);
            }
        } else {
            List segmentsExperiences = ListUtil.fromArray((Object[])new SegmentsExperience[]{swapSegmentsExperience});
            segmentsExperiences.addAll(this.segmentsExperiencePersistence.findByG_C_C_LtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), priority));
            for (int i = segmentsExperiences.size(); i > 0; --i) {
                SegmentsExperience curSegmentsExperience = (SegmentsExperience)segmentsExperiences.get(i - 1);
                this._updateSegmentsExperiencePriorityAndFlush(curSegmentsExperience.getPriority() - 1, curSegmentsExperience);
            }
        }
    }

    private void _updateSegmentsExperiencePriorityAndFlush(int priority, SegmentsExperience segmentsExperience) {
        segmentsExperience.setPriority(priority);
        this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        this.segmentsExperiencePersistence.flush();
    }

    private void _validateName(Map<Locale, String> nameMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (nameMap.isEmpty() || Validator.isNull((String)nameMap.get(locale))) {
            throw new SegmentsExperienceNameException();
        }
    }

    private void _validatePriority(long groupId, long classNameId, long classPK, int priority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(groupId, classNameId, classPK, priority);
        if (segmentsExperience != null) {
            throw new SegmentsExperiencePriorityException("A segments experience with the priority " + priority + " already exists");
        }
    }
}

