/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.context;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceDetectionUtil;
import com.liferay.portal.kernel.mobile.device.Dimensions;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IdEntityField;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.segments.context.Context;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.context.contributor.RequestContextContributor;
import com.liferay.segments.internal.odata.entity.ContextEntityModel;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={RequestContextMapper.class})
public class RequestContextMapperImpl
implements RequestContextMapper {
    private static final Log _log = LogFactoryUtil.getLog(RequestContextMapperImpl.class);
    @Reference
    private BrowserSniffer _browserSniffer;
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, RequestContextContributor> _requestContextContributorServiceTrackerMap;
    private final Map<ServiceReference<RequestContextContributor>, ServiceRegistration<EntityModel>> _serviceRegistrations = new ConcurrentHashMap<ServiceReference<RequestContextContributor>, ServiceRegistration<EntityModel>>();

    public Context map(HttpServletRequest httpServletRequest) {
        User user;
        Context context;
        block7: {
            context = new Context();
            context.put("browser", (Serializable)((Object)this._browserSniffer.getBrowserId(httpServletRequest)));
            context.put("cookies", (Serializable)this._getCookies(httpServletRequest));
            Device device = DeviceDetectionUtil.detectDevice((HttpServletRequest)httpServletRequest);
            Dimensions screenResolutionDimensions = null;
            if (device != null && !Objects.equals(device, UnknownDevice.getInstance())) {
                context.put("deviceBrand", (Serializable)((Object)device.getBrand()));
                context.put("deviceModel", (Serializable)((Object)device.getModel()));
                screenResolutionDimensions = device.getScreenResolution();
            } else {
                context.put("deviceBrand", (Serializable)((Object)""));
                context.put("deviceModel", (Serializable)((Object)""));
                screenResolutionDimensions = Dimensions.UNKNOWN;
            }
            context.put("deviceScreenResolutionHeight", (Serializable)Double.valueOf(screenResolutionDimensions.getHeight()));
            context.put("deviceScreenResolutionWidth", (Serializable)Double.valueOf(screenResolutionDimensions.getWidth()));
            context.put("hostname", (Serializable)((Object)httpServletRequest.getServerName()));
            context.put("languageId", (Serializable)((Object)LocaleUtil.toLanguageId((Locale)this._portal.getLocale(httpServletRequest))));
            user = null;
            try {
                user = this._portal.initUser(httpServletRequest);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Throwable)exception);
            }
        }
        ZonedDateTime lastSignInZonedDateTime = ZonedDateTime.of(LocalDateTime.MIN, ZoneOffset.UTC);
        if (user != null && user.getLastLoginDate() != null) {
            Date lastLoginDate = user.getLastLoginDate();
            lastSignInZonedDateTime = ZonedDateTime.ofInstant(lastLoginDate.toInstant(), ZoneOffset.UTC);
        }
        context.put("lastSignInDateTime", (Serializable)lastSignInZonedDateTime);
        context.put("localDate", (Serializable)LocalDate.from(ZonedDateTime.now()));
        context.put("referrerURL", (Serializable)((Object)GetterUtil.getString((String)httpServletRequest.getHeader("Referer"))));
        context.put("requestParameters", (Serializable)this._getRequestParameters(httpServletRequest));
        boolean signedIn = false;
        if (user != null) {
            signedIn = !user.isDefaultUser();
        }
        context.put("signedIn", (Serializable)Boolean.valueOf(signedIn));
        context.put("url", (Serializable)((Object)this._portal.getCurrentCompleteURL(httpServletRequest)));
        String userAgent = GetterUtil.getString((String)httpServletRequest.getHeader("User-Agent"));
        context.put("userAgent", (Serializable)((Object)userAgent));
        for (RequestContextContributor requestContextContributor : this._requestContextContributorServiceTrackerMap.values()) {
            requestContextContributor.contribute(context, httpServletRequest);
        }
        return context;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._requestContextContributorServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, RequestContextContributor.class, (String)"request.context.contributor.key", (ServiceTrackerCustomizer)new RequestContextContributorServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<EntityModel> serviceRegistration : this._serviceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
        this._requestContextContributorServiceTrackerMap.close();
    }

    private String[] _getCookies(HttpServletRequest httpServletRequest) {
        Cookie[] httpServletRequestCookies = httpServletRequest.getCookies();
        if (httpServletRequestCookies == null) {
            return new String[0];
        }
        String[] cookies = new String[httpServletRequestCookies.length];
        for (int i = 0; i < httpServletRequestCookies.length; ++i) {
            cookies[i] = httpServletRequestCookies[i].getName() + "=" + httpServletRequestCookies[i].getValue();
        }
        return cookies;
    }

    private String[] _getRequestParameters(HttpServletRequest httpServletRequest) {
        Map parameterMap = httpServletRequest.getParameterMap();
        if (parameterMap.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> requestParameters = new ArrayList<String>();
        for (Map.Entry entry : parameterMap.entrySet()) {
            requestParameters.add((String)entry.getKey() + "=" + StringUtil.merge((Object[])((Object[])entry.getValue())));
        }
        return requestParameters.toArray(new String[0]);
    }

    private class RequestContextContributorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<RequestContextContributor, RequestContextContributor> {
        private final BundleContext _bundleContext;
        private final Map<String, EntityField> _customEntityFields = new HashMap<String, EntityField>();
        private ServiceRegistration<EntityModel> _serviceRegistration;

        public RequestContextContributor addingService(ServiceReference<RequestContextContributor> serviceReference) {
            String requestContextContributorKey = GetterUtil.getString((Object)serviceReference.getProperty("request.context.contributor.key"));
            String requestContextContributorType = GetterUtil.getString((Object)serviceReference.getProperty("request.context.contributor.type"));
            List<EntityField> customEntityFields = this._addCustomEntityField(requestContextContributorKey, requestContextContributorType);
            this._register(this._bundleContext, new ContextEntityModel(customEntityFields));
            return (RequestContextContributor)this._bundleContext.getService(serviceReference);
        }

        public void modifiedService(ServiceReference<RequestContextContributor> serviceReference, RequestContextContributor requestContextContributor) {
            this.removedService(serviceReference, requestContextContributor);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<RequestContextContributor> serviceReference, RequestContextContributor requestContextContributor) {
            String requestContextContributorKey = GetterUtil.getString((Object)serviceReference.getProperty("request.context.contributor.key"));
            List<EntityField> customEntityFields = this._removeCustomEntityField(requestContextContributorKey);
            this._register(this._bundleContext, new ContextEntityModel(customEntityFields));
            this._bundleContext.ungetService(serviceReference);
        }

        private RequestContextContributorServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
            this._register(bundleContext, new ContextEntityModel(Collections.emptyList()));
        }

        private List<EntityField> _addCustomEntityField(String contextFieldKey, String contextFieldType) {
            Object entityField = null;
            entityField = contextFieldType.equals("boolean") ? new BooleanEntityField(contextFieldKey, locale -> contextFieldKey) : (contextFieldType.equals("date") ? new DateTimeEntityField(contextFieldKey, locale -> Field.getSortableFieldName((String)contextFieldKey), locale -> contextFieldKey) : (contextFieldType.equals("double") ? new DoubleEntityField(contextFieldKey, locale -> contextFieldKey) : (contextFieldType.equals("id") ? new IdEntityField(contextFieldKey, locale -> Field.getSortableFieldName((String)contextFieldKey), locale -> contextFieldKey) : (contextFieldType.equals("integer") ? new IntegerEntityField(contextFieldKey, locale -> contextFieldKey) : new StringEntityField(contextFieldKey, locale -> contextFieldKey)))));
            this._customEntityFields.put(contextFieldKey, (EntityField)entityField);
            return new ArrayList<EntityField>(this._customEntityFields.values());
        }

        private void _register(BundleContext bundleContext, ContextEntityModel contextEntityModel) {
            if (this._serviceRegistration != null) {
                this._serviceRegistration.unregister();
            }
            this._serviceRegistration = bundleContext.registerService(EntityModel.class, (Object)contextEntityModel, MapUtil.singletonDictionary((Object)"entity.model.name", (Object)"Context"));
        }

        private List<EntityField> _removeCustomEntityField(String requestContextContributorKey) {
            this._customEntityFields.remove(requestContextContributorKey);
            return new ArrayList<EntityField>(this._customEntityFields.values());
        }
    }
}

