/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.upgrade.v2_6_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SegmentsExperienceUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsExperienceUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._updateSegmentsExperiencePriorities();
    }

    private void _updateSegmentsExperience(long segmentsExperienceId, int priority) {
        block14: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update SegmentsExperience set priority = ? where segmentsExperienceId = ?");){
                preparedStatement.setInt(1, priority + 1);
                preparedStatement.setLong(2, segmentsExperienceId);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block14;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _updateSegmentsExperiencePriorities() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select segmentsExperienceId, priority from SegmentsExperience where priority >= 0 and segmentsExperienceKey != ?");){
            preparedStatement.setString(1, "DEFAULT");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long segmentsExperienceId = resultSet.getLong("segmentsExperienceId");
                    int priority = resultSet.getInt("priority");
                    this._updateSegmentsExperience(segmentsExperienceId, priority);
                }
            }
        }
    }
}

