/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.provider;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.context.Context;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.internal.provider.BaseSegmentsEntryProvider;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.odata.matcher.ODataMatcher;
import com.liferay.segments.odata.retriever.ODataRetriever;
import com.liferay.segments.provider.SegmentsEntryProvider;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"segments.entry.provider.order:Integer=200", "segments.entry.provider.source=REFERRED"}, service={SegmentsEntryProvider.class})
public class ReferredSegmentsEntryProvider
extends BaseSegmentsEntryProvider
implements SegmentsEntryProvider {
    private static final Log _log = LogFactoryUtil.getLog(ReferredSegmentsEntryProvider.class);
    @Reference(target="(target.class.name=com.liferay.segments.model.SegmentsEntry)")
    private ODataMatcher<Map<String, String>> _segmentsEntryODataMatcher;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ODataRetriever.class, (String)"model.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this.serviceTrackerMap.close();
    }

    @Override
    protected String getSource() {
        return "REFERRED";
    }

    @Override
    protected boolean isMember(String className, long classPK, Context context, SegmentsEntry segmentsEntry, long[] segmentsEntryIds) {
        Criteria criteria = segmentsEntry.getCriteriaObj();
        if (criteria == null || MapUtil.isEmpty((Map)criteria.getCriteria())) {
            return false;
        }
        Criteria.Conjunction referredConjunction = this.getConjunction(segmentsEntry, Criteria.Type.REFERRED);
        String referredFilterString = this.getFilterString(segmentsEntry, Criteria.Type.REFERRED);
        boolean member = super.isMember(className, classPK, context, segmentsEntry, segmentsEntryIds);
        if (ArrayUtil.isEmpty((long[])segmentsEntryIds) || Validator.isNull((String)referredFilterString) || member && referredConjunction.equals((Object)Criteria.Conjunction.OR) || !member && referredConjunction.equals((Object)Criteria.Conjunction.AND)) {
            return member;
        }
        HashMap segmentsEntryMap = HashMapBuilder.put((Object)"segmentsEntryIds", (Object)StringUtil.merge((long[])segmentsEntryIds, (String)",")).build();
        try {
            return this._segmentsEntryODataMatcher.matches(referredFilterString, (Object)segmentsEntryMap);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return member;
        }
    }
}

