/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.configuration.provider;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.segments.configuration.SegmentsCompanyConfiguration;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.configuration.provider.SegmentsConfigurationProvider;
import java.io.IOException;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={SegmentsConfigurationProvider.class})
public class SegmentsConfigurationProviderImpl
implements SegmentsConfigurationProvider {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private volatile SegmentsConfiguration _segmentsConfiguration;

    public boolean isRoleSegmentationEnabled(long companyId) throws ConfigurationException {
        if (!this._segmentsConfiguration.roleSegmentationEnabled()) {
            return false;
        }
        if (!this._isSegmentsCompanyConfigurationDefined(companyId)) {
            return this._segmentsConfiguration.roleSegmentationEnabled();
        }
        SegmentsCompanyConfiguration segmentsCompanyConfiguration = (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId);
        return segmentsCompanyConfiguration.roleSegmentationEnabled();
    }

    public boolean isSegmentationEnabled(long companyId) throws ConfigurationException {
        if (!this._segmentsConfiguration.segmentationEnabled()) {
            return false;
        }
        if (!this._isSegmentsCompanyConfigurationDefined(companyId)) {
            return this._segmentsConfiguration.segmentationEnabled();
        }
        SegmentsCompanyConfiguration segmentsCompanyConfiguration = (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId);
        return segmentsCompanyConfiguration.segmentationEnabled();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
    }

    private boolean _isSegmentsCompanyConfigurationDefined(long companyId) throws ConfigurationException {
        try {
            String filterString = StringBundler.concat((Object[])new Object[]{"(&(", "service.factoryPid", "=", SegmentsCompanyConfiguration.class.getName(), ".scoped", ")(companyId=", companyId, "))"});
            Configuration[] configuration = this._configurationAdmin.listConfigurations(filterString);
            return configuration != null;
        }
        catch (IOException | InvalidSyntaxException exception) {
            throw new ConfigurationException(exception);
        }
    }
}

