/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.base.SegmentsExperimentServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=segments", "json.web.service.context.path=SegmentsExperiment"}, service={AopService.class})
public class SegmentsExperimentServiceImpl
extends SegmentsExperimentServiceBaseImpl {
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference(target="(model.class.name=com.liferay.segments.model.SegmentsExperiment)")
    private ModelResourcePermission<SegmentsExperiment> _segmentsExperimentResourcePermission;

    public SegmentsExperiment addSegmentsExperiment(long segmentsExperienceId, long classNameId, long classPK, String name, String description, String goal, String goalTarget, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)classPK, (String)"UPDATE");
        return this.segmentsExperimentLocalService.addSegmentsExperiment(segmentsExperienceId, classNameId, classPK, name, description, goal, goalTarget, serviceContext);
    }

    public SegmentsExperiment deleteSegmentsExperiment(long segmentsExperimentId) throws PortalException {
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentId), "DELETE");
        return this.segmentsExperimentLocalService.deleteSegmentsExperiment(segmentsExperimentId);
    }

    public SegmentsExperiment deleteSegmentsExperiment(String segmentsExperimentKey) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentKey);
        this._checkPermissions(segmentsExperiment, "DELETE");
        return this.segmentsExperimentLocalService.deleteSegmentsExperiment(segmentsExperiment);
    }

    public SegmentsExperiment fetchSegmentsExperiment(long segmentsExperienceId, long classNameId, long classPK, int[] statuses) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)classPK, (String)"UPDATE");
        return this.segmentsExperimentLocalService.fetchSegmentsExperiment(segmentsExperienceId, classNameId, classPK, statuses);
    }

    public SegmentsExperiment fetchSegmentsExperiment(long groupId, String segmentsExperimentKey) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.fetchSegmentsExperiment(groupId, segmentsExperimentKey);
        if (segmentsExperiment != null && this._segmentsExperimentResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)segmentsExperiment, "VIEW")) {
            return segmentsExperiment;
        }
        return null;
    }

    public List<SegmentsExperiment> getSegmentsExperienceSegmentsExperiments(long[] segmentsExperienceIds, long classNameId, long classPK, int[] statuses, int start, int end) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)classPK, (String)"UPDATE");
        return this.segmentsExperimentLocalService.getSegmentsExperienceSegmentsExperiments(segmentsExperienceIds, classNameId, classPK, statuses, start, end);
    }

    public SegmentsExperiment getSegmentsExperiment(long segmentsExperimentId) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentId);
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperiment, "VIEW");
        return segmentsExperiment;
    }

    public SegmentsExperiment getSegmentsExperiment(String segmentsExperimentKey) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentKey);
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperiment, "VIEW");
        return segmentsExperiment;
    }

    public List<SegmentsExperiment> getSegmentsExperiments(long groupId, long classNameId, long classPK) {
        return this.segmentsExperimentPersistence.filterFindByG_C_C(groupId, classNameId, classPK);
    }

    public List<SegmentsExperiment> getSegmentsExperiments(long segmentsExperienceId, long classNameId, long classPK, int[] statuses, OrderByComparator<SegmentsExperiment> orderByComparator) {
        return this.segmentsExperimentLocalService.getSegmentsExperiments(segmentsExperienceId, classNameId, classPK, statuses, orderByComparator);
    }

    public SegmentsExperiment runSegmentsExperiment(long segmentsExperimentId, double confidenceLevel, Map<Long, Double> segmentsExperienceIdSplitMap) throws PortalException {
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentId), "UPDATE");
        return this.segmentsExperimentLocalService.runSegmentsExperiment(segmentsExperimentId, confidenceLevel, segmentsExperienceIdSplitMap);
    }

    public SegmentsExperiment runSegmentsExperiment(String segmentsExperimentKey, double confidenceLevel, Map<String, Double> segmentsExperienceKeySplitMap) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentKey);
        this._checkPermissions(segmentsExperiment, "UPDATE");
        Set<Map.Entry<String, Double>> segmentsExperienceKeySplits = segmentsExperienceKeySplitMap.entrySet();
        Stream segmentsExperienceKeySplitsStream = segmentsExperienceKeySplits.stream();
        Map<Long, Double> segmentsExperienceIdSplitMap = segmentsExperienceKeySplitsStream.collect(Collectors.toMap(entry -> this._getSegmentsExperienceId(segmentsExperiment.getGroupId(), (String)entry.getKey(), segmentsExperiment.getClassNameId(), segmentsExperiment.getClassPK()), Map.Entry::getValue));
        return this.segmentsExperimentLocalService.runSegmentsExperiment(segmentsExperiment.getSegmentsExperimentId(), confidenceLevel, segmentsExperienceIdSplitMap);
    }

    public SegmentsExperiment updateSegmentsExperiment(long segmentsExperimentId, String name, String description, String goal, String goalTarget) throws PortalException {
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentId), "UPDATE");
        return this.segmentsExperimentLocalService.updateSegmentsExperiment(segmentsExperimentId, name, description, goal, goalTarget);
    }

    public SegmentsExperiment updateSegmentsExperimentStatus(long segmentsExperimentId, int status) throws PortalException {
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentId), "UPDATE");
        return this.segmentsExperimentLocalService.updateSegmentsExperimentStatus(segmentsExperimentId, status);
    }

    public SegmentsExperiment updateSegmentsExperimentStatus(long segmentsExperimentId, long winnerSegmentsExperienceId, int status) throws PortalException {
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentId), "UPDATE");
        return this.segmentsExperimentLocalService.updateSegmentsExperimentStatus(segmentsExperimentId, winnerSegmentsExperienceId, status);
    }

    public SegmentsExperiment updateSegmentsExperimentStatus(String segmentsExperimentKey, int status) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentKey);
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperiment, "UPDATE");
        return this.segmentsExperimentLocalService.updateSegmentsExperimentStatus(segmentsExperiment.getSegmentsExperimentId(), status);
    }

    public SegmentsExperiment updateSegmentsExperimentStatus(String segmentsExperimentKey, String winnerSegmentsExperienceKey, int status) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentKey);
        this._checkPermissions(segmentsExperiment, "UPDATE");
        return this.segmentsExperimentLocalService.updateSegmentsExperimentStatus(segmentsExperiment.getSegmentsExperimentId(), this._getSegmentsExperienceId(segmentsExperiment.getGroupId(), winnerSegmentsExperienceKey, segmentsExperiment.getClassNameId(), segmentsExperiment.getClassPK()), status);
    }

    private void _checkPermissions(SegmentsExperiment segmentsExperiment, String actionId) throws PortalException {
        if (this.userLocalService.hasRoleUser(segmentsExperiment.getCompanyId(), "Analytics Administrator", this.getUserId(), true)) {
            return;
        }
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperiment, actionId);
    }

    private long _getSegmentsExperienceId(long groupId, String segmentsExperienceKey, long classNameId, long classPK) {
        SegmentsExperience segmentsExperience;
        if (Objects.equals(segmentsExperienceKey, "DEFAULT")) {
            return 0L;
        }
        if (Validator.isNotNull((String)segmentsExperienceKey) && (segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(groupId, segmentsExperienceKey, classNameId, classPK)) != null) {
            return segmentsExperience.getSegmentsExperienceId();
        }
        return -1L;
    }
}

