/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.base.SegmentsExperienceServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=segments", "json.web.service.context.path=SegmentsExperience"}, service={AopService.class})
public class SegmentsExperienceServiceImpl
extends SegmentsExperienceServiceBaseImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference(target="(resource.name=com.liferay.segments)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference(target="(model.class.name=com.liferay.segments.model.SegmentsExperience)")
    private ModelResourcePermission<SegmentsExperience> _segmentsExperienceResourcePermission;

    public SegmentsExperience addSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        if (!this._hasUpdateLayoutPermission(this._getPublishedLayoutClassPK(classPK))) {
            this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        }
        return this.segmentsExperienceLocalService.addSegmentsExperience(segmentsEntryId, classNameId, classPK, nameMap, active, typeSettingsUnicodeProperties, serviceContext);
    }

    public SegmentsExperience appendSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.appendSegmentsExperience(segmentsEntryId, classNameId, classPK, nameMap, active, new UnicodeProperties(true), serviceContext);
    }

    public SegmentsExperience appendSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        if (!this._hasUpdateLayoutPermission(this._getPublishedLayoutClassPK(classPK))) {
            this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        }
        return this.segmentsExperienceLocalService.appendSegmentsExperience(segmentsEntryId, classNameId, classPK, nameMap, active, typeSettingsUnicodeProperties, serviceContext);
    }

    public SegmentsExperience deleteSegmentsExperience(long segmentsExperienceId) throws PortalException {
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId), "DELETE");
        return this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperienceId);
    }

    public SegmentsExperience fetchSegmentsExperience(long groupId, String segmentsExperienceKey, long classNameId, long classPK) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(groupId, segmentsExperienceKey, classNameId, classPK);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "VIEW");
        return segmentsExperience;
    }

    public SegmentsExperience getSegmentsExperience(long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "VIEW");
        return segmentsExperience;
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active) throws PortalException {
        long publishedLayoutClassPK = this._getPublishedLayoutClassPK(classPK);
        if (this._hasUpdateLayoutPermission(publishedLayoutClassPK)) {
            return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, publishedLayoutClassPK, active);
        }
        return this.segmentsExperiencePersistence.filterFindByG_C_C_A(groupId, classNameId, publishedLayoutClassPK, active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) throws PortalException {
        long publishedLayoutClassPK = this._getPublishedLayoutClassPK(classPK);
        if (this._hasUpdateLayoutPermission(publishedLayoutClassPK)) {
            return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, publishedLayoutClassPK, active, start, end, orderByComparator);
        }
        return this.segmentsExperiencePersistence.filterFindByG_C_C_A(groupId, classNameId, publishedLayoutClassPK, active, start, end, orderByComparator);
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK, boolean active) throws PortalException {
        long publishedLayoutClassPK = this._getPublishedLayoutClassPK(classPK);
        if (this._hasUpdateLayoutPermission(publishedLayoutClassPK)) {
            return this.segmentsExperiencePersistence.countByG_C_C_A(groupId, classNameId, publishedLayoutClassPK, active);
        }
        return this.segmentsExperiencePersistence.filterCountByG_C_C_A(groupId, classNameId, publishedLayoutClassPK, active);
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active) throws PortalException {
        SegmentsExperience segmentsExperience = this.getSegmentsExperience(segmentsExperienceId);
        return this.updateSegmentsExperience(segmentsExperienceId, segmentsEntryId, nameMap, active, segmentsExperience.getTypeSettingsUnicodeProperties());
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties) throws PortalException {
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId), "UPDATE");
        return this.segmentsExperienceLocalService.updateSegmentsExperience(segmentsExperienceId, segmentsEntryId, nameMap, active, typeSettingsUnicodeProperties);
    }

    public void updateSegmentsExperiencePriority(long segmentsExperienceId, int newPriority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "UPDATE");
        SegmentsExperience swapSegmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), newPriority);
        if (swapSegmentsExperience != null) {
            this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)swapSegmentsExperience, "UPDATE");
        }
        this.segmentsExperienceLocalService.updateSegmentsExperiencePriority(segmentsExperienceId, newPriority);
    }

    private long _getPublishedLayoutClassPK(long classPK) {
        Layout layout = this._layoutLocalService.fetchLayout(classPK);
        if (layout != null && layout.isDraftLayout()) {
            return layout.getClassPK();
        }
        return classPK;
    }

    private boolean _hasUpdateLayoutPermission(long plid) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        return layout != null && LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
    }
}

