/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.model.listener;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeIndexer;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import com.liferay.segments.internal.odata.entity.UserEntityModel;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserExpandoColumnModelListener
extends BaseModelListener<ExpandoColumn> {
    private static final Log _log = LogFactoryUtil.getLog(UserExpandoColumnModelListener.class);
    private BundleContext _bundleContext;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private EntityModelFieldMapper _entityModelFieldMapper;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    private ServiceRegistration<EntityModel> _serviceRegistration;
    private Map<Long, EntityField> _userEntityFields = new HashMap<Long, EntityField>();

    public void onAfterCreate(ExpandoColumn expandoColumn) throws ModelListenerException {
        try {
            if (!this._isUserCustomField(expandoColumn)) {
                return;
            }
            Optional<EntityField> userEntityFieldOptional = this._getUserEntityFieldOptional(expandoColumn);
            userEntityFieldOptional.ifPresent(entityField -> {
                this._userEntityFields.put(expandoColumn.getColumnId(), (EntityField)entityField);
                this._serviceRegistration = this._updateRegistry(this._bundleContext, this._serviceRegistration, this._userEntityFields);
            });
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterRemove(ExpandoColumn expandoColumn) throws ModelListenerException {
        if (expandoColumn == null) {
            return;
        }
        if (this._userEntityFields.containsKey(expandoColumn.getColumnId())) {
            this._userEntityFields.remove(expandoColumn.getColumnId());
            this._serviceRegistration = this._updateRegistry(this._bundleContext, this._serviceRegistration, this._userEntityFields);
        }
    }

    public void onAfterUpdate(ExpandoColumn originalExpandoColumn, ExpandoColumn expandoColumn) throws ModelListenerException {
        if (expandoColumn == null) {
            return;
        }
        this._userEntityFields.remove(expandoColumn.getColumnId());
        this.onAfterCreate(expandoColumn);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        try {
            this._bundleContext = bundleContext;
            this._userEntityFields = this._getUserEntityFields();
            this._serviceRegistration = this._register(this._bundleContext, this._userEntityFields);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    @Deactivate
    protected void deactivate() {
        this._unregister(this._serviceRegistration);
    }

    private DynamicQuery _getTableDynamicQuery(long classNameId, String name) {
        DynamicQuery dynamicQuery = this._expandoTableLocalService.dynamicQuery();
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
        Property nameProperty = PropertyFactoryUtil.forName((String)"name");
        dynamicQuery.add(nameProperty.eq((Object)name));
        dynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"tableId"));
        return dynamicQuery;
    }

    private Optional<EntityField> _getUserEntityFieldOptional(ExpandoColumn expandoColumn) {
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        int indexType = GetterUtil.getInteger((String)((String)unicodeProperties.get((Object)"index-type")));
        if (indexType == 0) {
            return Optional.empty();
        }
        String encodedName = this._entityModelFieldMapper.getExpandoColumnEntityFieldName(expandoColumn);
        String encodedIndexedFieldName = this._expandoBridgeIndexer.encodeFieldName(expandoColumn.getName(), indexType);
        Object entityField = null;
        entityField = expandoColumn.getType() == 1 ? new BooleanEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 3 ? new DateTimeEntityField(encodedName, locale -> Field.getSortableFieldName((String)encodedIndexedFieldName), locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 5 || expandoColumn.getType() == 6 || expandoColumn.getType() == 7 || expandoColumn.getType() == 8 ? new DoubleEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 9 || expandoColumn.getType() == 10 || expandoColumn.getType() == 11 || expandoColumn.getType() == 12 || expandoColumn.getType() == 13 || expandoColumn.getType() == 14 ? new IntegerEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 20 ? new StringEntityField(encodedName, locale -> Field.getLocalizedName((Locale)locale, (String)encodedIndexedFieldName)) : new StringEntityField(encodedName, locale -> encodedIndexedFieldName)))));
        return Optional.of(entityField);
    }

    private Map<Long, EntityField> _getUserEntityFields() throws PortalException {
        HashMap<Long, EntityField> userEntityFieldsMap = new HashMap<Long, EntityField>();
        ActionableDynamicQuery columnActionableDynamicQuery = this._expandoColumnLocalService.getActionableDynamicQuery();
        columnActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property tableProperty = PropertyFactoryUtil.forName((String)"tableId");
            long userClassNameId = this._classNameLocalService.getClassNameId(User.class.getName());
            dynamicQuery.add(tableProperty.in(this._getTableDynamicQuery(userClassNameId, "CUSTOM_FIELDS")));
        });
        columnActionableDynamicQuery.setPerformActionMethod(expandoColumn -> {
            Optional<EntityField> userEntityFieldOptional = this._getUserEntityFieldOptional((ExpandoColumn)expandoColumn);
            userEntityFieldOptional.ifPresent(entityField -> userEntityFieldsMap.put(expandoColumn.getColumnId(), (EntityField)entityField));
        });
        columnActionableDynamicQuery.performActions();
        return userEntityFieldsMap;
    }

    private boolean _isUserCustomField(ExpandoColumn expandoColumn) throws PortalException {
        long userClassNameId = this._classNameLocalService.getClassNameId(User.class.getName());
        ExpandoTable expandoTable = this._expandoTableLocalService.getTable(expandoColumn.getTableId());
        return expandoTable.getClassNameId() == userClassNameId && "CUSTOM_FIELDS".equals(expandoTable.getName());
    }

    private ServiceRegistration<EntityModel> _register(BundleContext bundleContext, Map<Long, EntityField> userEntityFieldsMap) {
        return bundleContext.registerService(EntityModel.class, (Object)new UserEntityModel(new ArrayList<EntityField>(userEntityFieldsMap.values())), (Dictionary)HashMapDictionaryBuilder.put((Object)"entity.model.name", (Object)"User").build());
    }

    private void _unregister(ServiceRegistration<EntityModel> serviceRegistration) {
        serviceRegistration.unregister();
    }

    private ServiceRegistration<EntityModel> _updateRegistry(BundleContext bundleContext, ServiceRegistration<EntityModel> serviceRegistration, Map<Long, EntityField> entityFieldsMap) {
        this._unregister(serviceRegistration);
        return this._register(bundleContext, entityFieldsMap);
    }
}

