/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.events;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.processor.SegmentsExperienceRequestProcessorRegistry;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={})
public class SegmentsServicePreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsServicePreAction.class);
    @Reference
    private Portal _portal;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private volatile SegmentsEntryRetriever _segmentsEntryRetriever;
    @Reference
    private SegmentsExperienceRequestProcessorRegistry _segmentsExperienceRequestProcessorRegistry;
    private ServiceRegistration<LifecycleAction> _serviceRegistration;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            this._run(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        SegmentsConfiguration segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
        if (segmentsConfiguration.segmentationEnabled()) {
            this._serviceRegistration = bundleContext.registerService(LifecycleAction.class, (Object)this, MapUtil.singletonDictionary((Object)"key", (Object)"servlet.service.events.pre"));
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private long[] _getSegmentsExperienceIds(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long groupId, long userId, long classNameId, long classPK) {
        block3: {
            try {
                long[] segmentsExperienceIds = this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(httpServletRequest, httpServletResponse, groupId, classNameId, classPK);
                if (segmentsExperienceIds.length > 0) {
                    long[] segmentsEntryIds = this._segmentsEntryRetriever.getSegmentsEntryIds(groupId, userId, this._requestContextMapper.map(httpServletRequest));
                    return ArrayUtil.append((long[])this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(httpServletRequest, httpServletResponse, groupId, classNameId, classPK, segmentsEntryIds), (long)0L);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
        return new long[]{0L};
    }

    private void _run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isLifecycleRender()) {
            return;
        }
        Layout layout = themeDisplay.getLayout();
        if (layout == null || !layout.isTypeContent() || layout.isTypeControlPanel()) {
            return;
        }
        httpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)this._getSegmentsExperienceIds(httpServletRequest, httpServletResponse, layout.getGroupId(), themeDisplay.getUserId(), this._portal.getClassNameId(Layout.class.getName()), layout.getPlid()));
    }
}

