/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.context.Context;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.simulator.SegmentsEntrySimulator;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SegmentsEntryRetriever.class})
public class SegmentsEntryRetrieverImpl
implements SegmentsEntryRetriever {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryRetrieverImpl.class);
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private volatile SegmentsEntrySimulator _segmentsEntrySimulator;

    public long[] getSegmentsEntryIds(long groupId, long userId, Context context) {
        Optional<long[]> segmentsEntryIdsOptional = this._getSegmentsEntryIdsOptional();
        long[] segmentsEntryIds = ArrayUtil.append((long[])segmentsEntryIdsOptional.orElseGet(() -> {
            if (this._segmentsEntrySimulator != null && this._segmentsEntrySimulator.isSimulationActive(userId)) {
                return this._segmentsEntrySimulator.getSimulatedSegmentsEntryIds(userId);
            }
            try {
                return this._segmentsEntryProviderRegistry.getSegmentsEntryIds(groupId, User.class.getName(), userId, context);
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)portalException);
                }
                return new long[0];
            }
        }), (long)0L);
        Optional<HttpServletRequest> httpServletRequestOptional = this._getHttpServletRequestOptional();
        httpServletRequestOptional.ifPresent(httpServletRequest -> httpServletRequest.setAttribute("SEGMENTS_ENTRY_IDS", (Object)segmentsEntryIds));
        return segmentsEntryIds;
    }

    private Optional<HttpServletRequest> _getHttpServletRequestOptional() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(serviceContext.getRequest());
    }

    private Optional<long[]> _getSegmentsEntryIdsOptional() {
        Optional<HttpServletRequest> httpServletRequestOptional = this._getHttpServletRequestOptional();
        return Optional.ofNullable(httpServletRequestOptional.map(httpServletRequest -> (long[])httpServletRequest.getAttribute("SEGMENTS_ENTRY_IDS")).orElse(null));
    }
}

