/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.security.permission.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsEntryRole;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryRoleLocalService;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={})
public class SegmentsEntryRoleContributor
implements RoleContributor {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryRoleContributor.class);
    @Reference(target="(permission.checker.type=liberal)")
    private PermissionCheckerFactory _liberalPermissionCheckerFactory;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference
    private SegmentsEntryRetriever _segmentsEntryRetriever;
    @Reference
    private SegmentsEntryRoleLocalService _segmentsEntryRoleLocalService;
    private ServiceRegistration<RoleContributor> _serviceRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contribute(RoleCollection roleCollection) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            if (permissionChecker != null) {
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._liberalPermissionCheckerFactory.create(permissionChecker.getUser()));
            }
            for (long segmentsEntryId : this._getSegmentsEntryIds(roleCollection)) {
                List segmentsEntryRoles = this._segmentsEntryRoleLocalService.getSegmentsEntryRoles(segmentsEntryId);
                for (SegmentsEntryRole segmentsEntryRole : segmentsEntryRoles) {
                    roleCollection.addRoleId(segmentsEntryRole.getRoleId());
                }
            }
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        SegmentsConfiguration segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
        if (segmentsConfiguration.roleSegmentationEnabled()) {
            this._serviceRegistration = bundleContext.registerService(RoleContributor.class, (Object)this, (Dictionary)new HashMapDictionary());
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private long[] _getSegmentsEntryIds(RoleCollection roleCollection) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return new long[0];
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return new long[0];
        }
        User user = roleCollection.getUser();
        long[] segmentsEntryIds = this._segmentsEntryRetriever.getSegmentsEntryIds(roleCollection.getGroupId(), user.getUserId(), this._requestContextMapper.map(httpServletRequest));
        if (segmentsEntryIds.length > 0 && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Found segments ", segmentsEntryIds, " for user ", user.getUserId(), " in group ", roleCollection.getGroupId()}));
        }
        return segmentsEntryIds;
    }
}

