/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.segments.model.SegmentsEntryRelModel;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={ModelDocumentContributor.class})
public class UserModelDocumentContributor
implements ModelDocumentContributor<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelDocumentContributor.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;

    public void contribute(Document document, User user) {
        block3: {
            try {
                long[] segmentsEntryIds = this.getSegmentsEntryIds(user);
                if (ArrayUtil.isNotEmpty((long[])segmentsEntryIds)) {
                    document.addKeyword("segmentsEntryIds", segmentsEntryIds);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to index user " + user.getUserId()), (Throwable)exception);
            }
        }
    }

    protected long[] getSegmentsEntryIds(User user) throws Exception {
        List segmentsEntryRels = this._segmentsEntryRelLocalService.getSegmentsEntryRels(this._portal.getClassNameId(User.class), user.getUserId());
        Stream stream = segmentsEntryRels.stream();
        return stream.mapToLong(SegmentsEntryRelModel::getSegmentsEntryId).toArray();
    }
}

