/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.search;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.segments.odata.search.ODataSearchAdapter;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ODataSearchAdapter.class})
public class ODataSearchAdapterImpl
implements ODataSearchAdapter {
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private SearchResultPermissionFilterFactory _searchResultPermissionFilterFactory;

    public Hits search(long companyId, FilterParser filterParser, String filterString, String className, EntityModel entityModel, Locale locale, int start, int end) throws PortalException {
        try {
            SearchContext searchContext = this._createSearchContext(companyId, start, end);
            Indexer indexer = this._indexerRegistry.getIndexer(className);
            searchContext.setBooleanClauses(new BooleanClause[]{this._getBooleanClause(filterString, entityModel, filterParser, locale)});
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new PortalException("Unable to search with filter " + filterString, (Throwable)exception);
        }
    }

    public int searchCount(long companyId, FilterParser filterParser, String filterString, String className, EntityModel entityModel, Locale locale) throws PortalException {
        try {
            SearchContext searchContext = this._createSearchContext(companyId, 0, 0);
            Indexer indexer = this._indexerRegistry.getIndexer(className);
            searchContext.setBooleanClauses(new BooleanClause[]{this._getBooleanClause(filterString, entityModel, filterParser, locale)});
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new PortalException("Unable to search with filter " + filterString, (Throwable)exception);
        }
    }

    private SearchContext _createSearchContext(long companyId, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        searchContext.setStart(start);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            searchContext.setUserId(permissionChecker.getUserId());
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private BooleanClause<Query> _getBooleanClause(String filterString, EntityModel entityModel, FilterParser filterParser, Locale locale) throws Exception {
        return BooleanClauseFactoryUtil.create((Query)this._getBooleanQuery(filterString, entityModel, filterParser, locale), (String)BooleanClauseOccur.MUST.getName());
    }

    private BooleanQuery _getBooleanQuery(String filterString, EntityModel entityModel, FilterParser filterParser, Locale locale) throws Exception {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        booleanQuery.add((Query)new MatchAllQuery(), BooleanClauseOccur.MUST);
        BooleanFilter booleanFilter = new BooleanFilter();
        Filter filter = this._getSearchFilter(filterString, entityModel, filterParser, locale);
        if (filter != null) {
            booleanFilter.add(filter, BooleanClauseOccur.MUST);
        }
        booleanQuery.setPreBooleanFilter(booleanFilter);
        return booleanQuery;
    }

    private Filter _getSearchFilter(String filterString, EntityModel entityModel, FilterParser filterParser, Locale locale) throws Exception {
        com.liferay.portal.odata.filter.Filter filter = new com.liferay.portal.odata.filter.Filter(filterParser.parse(filterString));
        if (filter == com.liferay.portal.odata.filter.Filter.emptyFilter()) {
            return null;
        }
        try {
            return (Filter)this._expressionConvert.convert(filter.getExpression(), locale, entityModel);
        }
        catch (Exception exception) {
            throw new InvalidFilterException("Invalid filter: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

