/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.SegmentsExperimentRel;
import com.liferay.segments.service.base.SegmentsExperimentRelServiceBaseImpl;
import com.liferay.segments.service.persistence.SegmentsExperimentPersistence;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=segments", "json.web.service.context.path=SegmentsExperimentRel"}, service={AopService.class})
public class SegmentsExperimentRelServiceImpl
extends SegmentsExperimentRelServiceBaseImpl {
    @Reference
    private SegmentsExperimentPersistence _segmentsExperimentPersistence;
    @Reference(target="(model.class.name=com.liferay.segments.model.SegmentsExperiment)")
    private ModelResourcePermission<SegmentsExperiment> _segmentsExperimentResourcePermission;
    @Reference
    private UserLocalService _userLocalService;

    public SegmentsExperimentRel addSegmentsExperimentRel(long segmentsExperimentId, long segmentsExperienceId, ServiceContext serviceContext) throws PortalException {
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), segmentsExperimentId, "UPDATE");
        return this.segmentsExperimentRelLocalService.addSegmentsExperimentRel(segmentsExperimentId, segmentsExperienceId, serviceContext);
    }

    public SegmentsExperimentRel deleteSegmentsExperimentRel(long segmentsExperimentRelId) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelPersistence.findByPrimaryKey(segmentsExperimentRelId);
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), segmentsExperimentRel.getSegmentsExperimentId(), "UPDATE");
        return this.segmentsExperimentRelLocalService.deleteSegmentsExperimentRel(segmentsExperimentRelId);
    }

    public SegmentsExperimentRel getSegmentsExperimentRel(long segmentsExperimentId, String segmentsExperienceKey) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelLocalService.getSegmentsExperimentRel(segmentsExperimentId, segmentsExperienceKey);
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), segmentsExperimentId, "VIEW");
        return segmentsExperimentRel;
    }

    public List<SegmentsExperimentRel> getSegmentsExperimentRels(long segmentsExperimentId) throws PortalException {
        SegmentsExperiment segmentsExperiment = this._segmentsExperimentPersistence.findByPrimaryKey(segmentsExperimentId);
        if (!this._userLocalService.hasRoleUser(segmentsExperiment.getCompanyId(), "Analytics Administrator", this.getUserId(), true)) {
            this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), segmentsExperimentId, "VIEW");
        }
        return this.segmentsExperimentRelLocalService.getSegmentsExperimentRels(segmentsExperimentId);
    }

    public SegmentsExperimentRel updateSegmentsExperimentRel(long segmentsExperimentRelId, double split) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelLocalService.getSegmentsExperimentRel(segmentsExperimentRelId);
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), segmentsExperimentRel.getSegmentsExperimentId(), "UPDATE");
        return this.segmentsExperimentRelLocalService.updateSegmentsExperimentRel(segmentsExperimentRelId, split);
    }

    public SegmentsExperimentRel updateSegmentsExperimentRel(long segmentsExperimentRelId, String name, ServiceContext serviceContext) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this.segmentsExperimentRelLocalService.getSegmentsExperimentRel(segmentsExperimentRelId);
        this._segmentsExperimentResourcePermission.check(this.getPermissionChecker(), segmentsExperimentRel.getSegmentsExperimentId(), "UPDATE");
        return this.segmentsExperimentRelLocalService.updateSegmentsExperimentRel(segmentsExperimentRelId, name, serviceContext);
    }
}

