/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.base.SegmentsEntryServiceBaseImpl;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=segments", "json.web.service.context.path=SegmentsEntry"}, service={AopService.class})
public class SegmentsEntryServiceImpl
extends SegmentsEntryServiceBaseImpl {
    @Reference
    private Portal _portal;
    @Reference(target="(resource.name=com.liferay.segments)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference(target="(model.class.name=com.liferay.segments.model.SegmentsEntry)")
    private ModelResourcePermission<SegmentsEntry> _segmentsEntryResourcePermission;

    public SegmentsEntry addSegmentsEntry(String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        return this.segmentsEntryLocalService.addSegmentsEntry(segmentsEntryKey, nameMap, descriptionMap, active, criteria, serviceContext);
    }

    public SegmentsEntry addSegmentsEntry(String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, String source, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        return this.segmentsEntryLocalService.addSegmentsEntry(segmentsEntryKey, nameMap, descriptionMap, active, criteria, source, serviceContext);
    }

    public void addSegmentsEntryClassPKs(long segmentsEntryId, long[] classPKs, ServiceContext serviceContext) throws PortalException {
        this._segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "UPDATE");
        this.segmentsEntryLocalService.addSegmentsEntryClassPKs(segmentsEntryId, classPKs, serviceContext);
    }

    public SegmentsEntry deleteSegmentsEntry(long segmentsEntryId) throws PortalException {
        this._segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "DELETE");
        return this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntryId);
    }

    public void deleteSegmentsEntryClassPKs(long segmentsEntryId, long[] classPKs) throws PortalException {
        this._segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "UPDATE");
        this.segmentsEntryLocalService.deleteSegmentsEntryClassPKs(segmentsEntryId, classPKs);
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId) {
        return this.segmentsEntryPersistence.filterFindByGroupId(this._portal.getCurrentAndAncestorSiteGroupIds(groupId));
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        return this.segmentsEntryPersistence.filterFindByGroupId(this._portal.getCurrentAndAncestorSiteGroupIds(groupId), start, end, orderByComparator);
    }

    public int getSegmentsEntriesCount(long groupId) {
        return this.segmentsEntryPersistence.filterCountByGroupId(this._portal.getCurrentAndAncestorSiteGroupIds(groupId));
    }

    public SegmentsEntry getSegmentsEntry(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryLocalService.getSegmentsEntry(segmentsEntryId);
        this._segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "VIEW");
        return segmentsEntry;
    }

    public BaseModelSearchResult<SegmentsEntry> searchSegmentsEntries(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "VIEW");
        return this.segmentsEntryLocalService.searchSegmentsEntries(companyId, groupId, keywords, new LinkedHashMap(), start, end, sort);
    }

    public SegmentsEntry updateSegmentsEntry(long segmentsEntryId, String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, ServiceContext serviceContext) throws PortalException {
        this._segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "UPDATE");
        return this.segmentsEntryLocalService.updateSegmentsEntry(segmentsEntryId, segmentsEntryKey, nameMap, descriptionMap, active, criteria, serviceContext);
    }
}

