/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.upgrade.v2_6_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SegmentsExperienceUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsExperienceUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._updateSegmentsExperiencePriorities();
    }

    private void _updateSegmentsExperience(long ctCollectionId, long segmentsExperienceId, int priority) {
        block8: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update SegmentsExperience set priority = ? where ctCollectionId = ? and segmentsExperienceId = ?");){
                preparedStatement.setInt(1, priority + 1);
                preparedStatement.setLong(2, ctCollectionId);
                preparedStatement.setLong(3, segmentsExperienceId);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _updateSegmentsExperiencePriorities() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select ctCollectionId, segmentsExperienceId, priority from SegmentsExperience where priority >= 0 and segmentsExperienceKey != ? order by priority desc");){
            preparedStatement.setString(1, "DEFAULT");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    this._updateSegmentsExperience(resultSet.getLong("ctCollectionId"), resultSet.getLong("segmentsExperienceId"), resultSet.getInt("priority"));
                }
            }
        }
    }
}

