/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.search;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.generic.TermRangeQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.segments.odata.search.ODataSearchAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ODataSearchAdapter.class})
public class ODataSearchAdapterImpl
implements ODataSearchAdapter {
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private IndexerRegistry _indexerRegistry;

    public Hits search(long companyId, FilterParser filterParser, String filterString, String className, EntityModel entityModel, Locale locale, int start, int end) throws PortalException {
        try {
            SearchContext searchContext = this._createSearchContext(companyId);
            return this.search(this._indexerRegistry.getIndexer(className), searchContext, this._getBooleanQuery(filterString, entityModel, filterParser, locale), start, end);
        }
        catch (Exception exception) {
            throw new PortalException("Unable to search with filter " + filterString, (Throwable)exception);
        }
    }

    public int searchCount(long companyId, FilterParser filterParser, String filterString, String className, EntityModel entityModel, Locale locale) throws PortalException {
        try {
            SearchContext searchContext = this._createSearchContext(companyId);
            Indexer indexer = this._indexerRegistry.getIndexer(className);
            searchContext.setBooleanClauses(new BooleanClause[]{this._getBooleanClause(this._getBooleanQuery(filterString, entityModel, filterParser, locale))});
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new PortalException("Unable to search with filter " + filterString, (Throwable)exception);
        }
    }

    protected Hits search(Indexer<?> indexer, SearchContext searchContext, BooleanQuery booleanQuery, int start, int end) throws PortalException {
        HitsImpl hits;
        ArrayList documentsList = new ArrayList();
        if (end == -1) {
            end = Integer.MAX_VALUE;
        }
        int indexSearchLimit = GetterUtil.getInteger((String)PropsUtil.get((String)"index.search.limit"));
        Document lastDocument = null;
        Sort sort = new Sort("entryClassPK", 6, false);
        searchContext.setSorts(new Sort[]{sort});
        if (start == -1) {
            start = 0;
        }
        while (start != end) {
            searchContext.setBooleanClauses(new BooleanClause[]{this._getBooleanClause(this._getLastDocumentBooleanQuery(booleanQuery, lastDocument, sort.getFieldName()))});
            searchContext.setEnd(Math.min(end, indexSearchLimit));
            searchContext.setStart(Math.min(start, indexSearchLimit - 1));
            hits = indexer.search(searchContext);
            Document[] documents = hits.getDocs();
            if (documents.length == 0) break;
            if (start < indexSearchLimit) {
                Collections.addAll(documentsList, documents);
                if (end < indexSearchLimit) break;
            }
            lastDocument = documents[documents.length - 1];
            start = Math.max(0, start - indexSearchLimit);
            end = Math.max(0, end - indexSearchLimit);
        }
        hits = new HitsImpl();
        hits.setDocs(documentsList.toArray(new Document[0]));
        hits.setLength(documentsList.size());
        hits.setStart(0L);
        return hits;
    }

    private SearchContext _createSearchContext(long companyId) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setGroupIds(new long[]{-1L});
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private BooleanClause<Query> _getBooleanClause(BooleanQuery booleanQuery) throws PortalException {
        return BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.MUST.getName());
    }

    private BooleanQuery _getBooleanQuery(String filterString, EntityModel entityModel, FilterParser filterParser, Locale locale) throws Exception {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        booleanQuery.add((Query)new MatchAllQuery(), BooleanClauseOccur.MUST);
        BooleanFilter booleanFilter = new BooleanFilter();
        Filter filter = this._getSearchFilter(filterString, entityModel, filterParser, locale);
        if (filter != null) {
            booleanFilter.add(filter, BooleanClauseOccur.MUST);
        }
        booleanQuery.setPreBooleanFilter(booleanFilter);
        return booleanQuery;
    }

    private BooleanQuery _getLastDocumentBooleanQuery(BooleanQuery booleanQuery, Document lastDocument, String sortField) throws ParseException {
        if (lastDocument == null) {
            return booleanQuery;
        }
        if (!lastDocument.hasField(sortField)) {
            throw new IllegalArgumentException("Missing " + sortField + " in the last document");
        }
        BooleanQueryImpl lastDocumentBooleanQuery = new BooleanQueryImpl();
        lastDocumentBooleanQuery.add((Query)booleanQuery, BooleanClauseOccur.MUST);
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(sortField, lastDocument.get(sortField), null, false, true);
        lastDocumentBooleanQuery.add((Query)termRangeQuery, BooleanClauseOccur.MUST);
        return lastDocumentBooleanQuery;
    }

    private Filter _getSearchFilter(String filterString, EntityModel entityModel, FilterParser filterParser, Locale locale) throws Exception {
        com.liferay.portal.odata.filter.Filter filter = new com.liferay.portal.odata.filter.Filter(filterParser.parse(filterString));
        if (filter == com.liferay.portal.odata.filter.Filter.emptyFilter()) {
            return null;
        }
        try {
            return (Filter)this._expressionConvert.convert(filter.getExpression(), locale, entityModel);
        }
        catch (Exception exception) {
            throw new InvalidFilterException("Invalid filter: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

