/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.segments.model.impl;

import com.liferay.segments.model.SegmentsEntryRel;
import com.liferay.segments.service.SegmentsEntryRelLocalServiceUtil;

/**
 * The extended model base implementation for the SegmentsEntryRel service. Represents a row in the &quot;SegmentsEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SegmentsEntryRelImpl}.
 * </p>
 *
 * @author Eduardo Garcia
 * @see SegmentsEntryRelImpl
 * @see SegmentsEntryRel
 * @generated
 */
public abstract class SegmentsEntryRelBaseImpl
	extends SegmentsEntryRelModelImpl implements SegmentsEntryRel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a segments entry rel model instance should use the <code>SegmentsEntryRel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SegmentsEntryRelLocalServiceUtil.addSegmentsEntryRel(this);
		}
		else {
			SegmentsEntryRelLocalServiceUtil.updateSegmentsEntryRel(this);
		}
	}

}