/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.CriteriaSerializer;
import com.liferay.segments.exception.RequiredSegmentsEntryException;
import com.liferay.segments.exception.SegmentsEntryKeyException;
import com.liferay.segments.exception.SegmentsEntryNameException;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import com.liferay.segments.service.SegmentsEntryRoleLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.base.SegmentsEntryLocalServiceBaseImpl;
import com.liferay.segments.service.persistence.SegmentsExperiencePersistence;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsEntry"}, service={AopService.class})
public class SegmentsEntryLocalServiceImpl
extends SegmentsEntryLocalServiceBaseImpl {
    @Reference
    private MessageBus _messageBus;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;
    @Reference
    private SegmentsEntryRoleLocalService _segmentsEntryRoleLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperiencePersistence _segmentsExperiencePersistence;
    @Reference
    private UserLocalService _userLocalService;

    public SegmentsEntry addSegmentsEntry(String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, ServiceContext serviceContext) throws PortalException {
        return this.segmentsEntryLocalService.addSegmentsEntry(segmentsEntryKey, nameMap, descriptionMap, active, criteria, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public SegmentsEntry addSegmentsEntry(String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, String source, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        segmentsEntryKey = Validator.isNull((String)segmentsEntryKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)segmentsEntryKey.trim());
        this._validateKey(0L, groupId, segmentsEntryKey);
        this._validateName(groupId, nameMap);
        long segmentsEntryId = this.counterLocalService.increment();
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.create(segmentsEntryId);
        segmentsEntry.setUuid(serviceContext.getUuid());
        segmentsEntry.setGroupId(groupId);
        segmentsEntry.setCompanyId(user.getCompanyId());
        segmentsEntry.setUserId(user.getUserId());
        segmentsEntry.setUserName(user.getFullName());
        segmentsEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsEntry.setSegmentsEntryKey(segmentsEntryKey);
        segmentsEntry.setNameMap(nameMap);
        segmentsEntry.setDescriptionMap(descriptionMap);
        segmentsEntry.setActive(active);
        segmentsEntry.setCriteria(criteria);
        segmentsEntry.setSource(this._getSource(criteria, source));
        segmentsEntry = (SegmentsEntry)this.segmentsEntryPersistence.update((BaseModel)segmentsEntry);
        this._resourceLocalService.addModelResources((AuditedModel)segmentsEntry, serviceContext);
        this._reindexSegmentsEntryRels1(segmentsEntry);
        return segmentsEntry;
    }

    public void addSegmentsEntryClassPKs(long segmentsEntryId, long[] classPKs, ServiceContext serviceContext) throws PortalException {
        SegmentsEntry segmentsEntry = this.getSegmentsEntry(segmentsEntryId);
        this._segmentsEntryRelLocalService.addSegmentsEntryRels(segmentsEntryId, this._portal.getClassNameId(User.class), classPKs, serviceContext);
        segmentsEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsEntry = (SegmentsEntry)this.segmentsEntryPersistence.update((BaseModel)segmentsEntry);
        this._reindexSegmentsEntryRels1(segmentsEntry);
    }

    public void deleteSegmentsEntries(long groupId) throws PortalException {
        List segmentsEntries = this.segmentsEntryPersistence.findByGroupId(groupId);
        for (SegmentsEntry segmentsEntry : segmentsEntries) {
            this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntry);
        }
    }

    public void deleteSegmentsEntries(String source) throws PortalException {
        List segmentsEntries = this.segmentsEntryPersistence.findBySource(source);
        for (SegmentsEntry segmentsEntry : segmentsEntries) {
            this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntry);
        }
    }

    @Override
    public SegmentsEntry deleteSegmentsEntry(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.findByPrimaryKey(segmentsEntryId);
        return this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntry);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public SegmentsEntry deleteSegmentsEntry(SegmentsEntry segmentsEntry) throws PortalException {
        int count;
        if (!GroupThreadLocal.isDeleteInProcess() && (count = this._segmentsExperiencePersistence.countBySegmentsEntryId(segmentsEntry.getSegmentsEntryId())) > 0) {
            throw new RequiredSegmentsEntryException.MustNotDeleteSegmentsEntryReferencedBySegmentsExperiences(segmentsEntry.getSegmentsEntryId());
        }
        this.segmentsEntryPersistence.remove((BaseModel)segmentsEntry);
        this._resourceLocalService.deleteResource((AuditedModel)segmentsEntry, 4);
        this._segmentsExperienceLocalService.deleteSegmentsEntrySegmentsExperiences(segmentsEntry.getSegmentsEntryId());
        this._segmentsEntryRelLocalService.deleteSegmentsEntryRels(segmentsEntry.getSegmentsEntryId());
        this._segmentsEntryRoleLocalService.deleteSegmentsEntryRoles(segmentsEntry.getSegmentsEntryId());
        this._reindexSegmentsEntryRels1(segmentsEntry);
        return segmentsEntry;
    }

    public void deleteSegmentsEntryClassPKs(long segmentsEntryId, long[] classPKs) throws PortalException {
        SegmentsEntry segmentsEntry = this.getSegmentsEntry(segmentsEntryId);
        this._segmentsEntryRelLocalService.deleteSegmentsEntryRels(segmentsEntryId, this._portal.getClassNameId(User.class), classPKs);
        segmentsEntry.setModifiedDate(new Date());
        segmentsEntry = (SegmentsEntry)this.segmentsEntryPersistence.update((BaseModel)segmentsEntry);
        this._reindexSegmentsEntryRels1(segmentsEntry);
    }

    public SegmentsEntry fetchSegmentsEntry(long groupId, String segmentsEntryKey) {
        SegmentsEntry segmentsEntry;
        if (Validator.isNotNull((String)segmentsEntryKey)) {
            segmentsEntryKey = StringUtil.toUpperCase((String)segmentsEntryKey.trim());
        }
        if ((segmentsEntry = this.segmentsEntryPersistence.fetchByG_S(groupId, segmentsEntryKey)) != null) {
            return segmentsEntry;
        }
        for (long ancestorSiteGroupId : this._portal.getAncestorSiteGroupIds(groupId)) {
            segmentsEntry = this.segmentsEntryPersistence.fetchByG_S(ancestorSiteGroupId, segmentsEntryKey);
            if (segmentsEntry == null) continue;
            return segmentsEntry;
        }
        return null;
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        return this.segmentsEntryPersistence.findByGroupId(this._portal.getCurrentAndAncestorSiteGroupIds(groupId), start, end, orderByComparator);
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId, String source, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        return this.segmentsEntryPersistence.findByG_SRC(this._portal.getCurrentAndAncestorSiteGroupIds(groupId), source, start, end, orderByComparator);
    }

    public List<SegmentsEntry> getSegmentsEntries(long[] segmentsEntryIds, int start, int end) {
        return this.segmentsEntryPersistence.findBySegmentsEntryId(segmentsEntryIds, start, end);
    }

    public List<SegmentsEntry> getSegmentsEntriesBySource(String source, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        return this.segmentsEntryPersistence.findBySource(source, start, end, orderByComparator);
    }

    public int getSegmentsEntriesCount(long groupId) {
        return this.segmentsEntryPersistence.countByGroupId(this._portal.getCurrentAndAncestorSiteGroupIds(groupId));
    }

    public BaseModelSearchResult<SegmentsEntry> searchSegmentsEntries(long companyId, long groupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, groupId, keywords, params, start, end, sort);
        return this.segmentsEntryLocalService.searchSegmentsEntries(searchContext);
    }

    public BaseModelSearchResult<SegmentsEntry> searchSegmentsEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(SegmentsEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<SegmentsEntry> segmentsEntries = this._getSegmentsEntries(hits);
            if (segmentsEntries == null) continue;
            return new BaseModelSearchResult(segmentsEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Indexable(type=IndexableType.REINDEX)
    public SegmentsEntry updateSegmentsEntry(long segmentsEntryId, String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, ServiceContext serviceContext) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.findByPrimaryKey(segmentsEntryId);
        segmentsEntryKey = StringUtil.toUpperCase((String)segmentsEntryKey.trim());
        this._validateKey(segmentsEntryId, segmentsEntry.getGroupId(), segmentsEntryKey);
        this._validateName(segmentsEntry.getGroupId(), nameMap);
        segmentsEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsEntry.setSegmentsEntryKey(segmentsEntryKey);
        segmentsEntry.setNameMap(nameMap);
        segmentsEntry.setDescriptionMap(descriptionMap);
        segmentsEntry.setActive(active);
        segmentsEntry.setCriteria(criteria);
        segmentsEntry.setSource(this._getSource(criteria, segmentsEntry.getSource()));
        segmentsEntry = (SegmentsEntry)this.segmentsEntryPersistence.update((BaseModel)segmentsEntry);
        this._reindexSegmentsEntryRels1(segmentsEntry);
        return segmentsEntry;
    }

    private SearchContext _buildSearchContext(long companyId, long groupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        HashMap attributes = HashMapBuilder.put((Object)"name", (Object)keywords).build();
        params.put("keywords", keywords);
        attributes.put("params", params);
        searchContext.setAttributes((Map)attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(this._portal.getCurrentAndAncestorSiteGroupIds(groupId));
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    private List<SegmentsEntry> _getSegmentsEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<SegmentsEntry> segmentsEntries = new ArrayList<SegmentsEntry>(documents.size());
        for (Document document : documents) {
            long segmentsEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            SegmentsEntry segmentsEntry = this.fetchSegmentsEntry(segmentsEntryId);
            if (segmentsEntry == null) {
                segmentsEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(SegmentsEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (segmentsEntries == null) continue;
            segmentsEntries.add(segmentsEntry);
        }
        return segmentsEntries;
    }

    private String _getSource(String criteria, String source) {
        if (Validator.isNotNull((String)criteria)) {
            Criteria deserializedCriteria = CriteriaSerializer.deserialize((String)criteria);
            String referredFilterString = deserializedCriteria.getFilterString(Criteria.Type.REFERRED);
            if (Validator.isNotNull((String)referredFilterString)) {
                return "REFERRED";
            }
            if ("REFERRED".equals(source) && Validator.isNull((String)referredFilterString)) {
                return "DEFAULT";
            }
        }
        if (Validator.isNull((String)source)) {
            return "DEFAULT";
        }
        return source;
    }

    private void _reindexReferredSegmentsEntryRels(SegmentsEntry segmentsEntry) throws PortalException {
        List referredSegmentsEntries = this.segmentsEntryPersistence.findBySource("REFERRED");
        for (SegmentsEntry referredSegmentsEntry : referredSegmentsEntries) {
            String filterString;
            Criteria criteria = referredSegmentsEntry.getCriteriaObj();
            Criteria.Criterion criterion = criteria.getCriterion("segments");
            if (criterion == null || !Validator.isNotNull((String)(filterString = criterion.getFilterString())) || !filterString.contains(String.valueOf(segmentsEntry.getSegmentsEntryId()))) continue;
            this._reindexSegmentsEntryRels2(referredSegmentsEntry);
        }
    }

    private void _reindexSegmentsEntryRels1(SegmentsEntry segmentsEntry) throws PortalException {
        this._reindexSegmentsEntryRels2(segmentsEntry);
        this._reindexReferredSegmentsEntryRels(segmentsEntry);
    }

    private void _reindexSegmentsEntryRels2(SegmentsEntry segmentsEntry) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("companyId", (Object)segmentsEntry.getCompanyId());
            message.put("segmentsEntryId", (Object)segmentsEntry.getSegmentsEntryId());
            this._messageBus.sendMessage("liferay/segments_entry_reindex", message);
            return null;
        });
    }

    private void _validateKey(long segmentsEntryId, long groupId, String segmentsEntryKey) throws PortalException {
        SegmentsEntry segmentsEntry = this.fetchSegmentsEntry(groupId, segmentsEntryKey);
        if (segmentsEntry != null && segmentsEntry.getSegmentsEntryId() != segmentsEntryId) {
            throw new SegmentsEntryKeyException();
        }
    }

    private void _validateName(long groupId, Map<Locale, String> nameMap) throws PortalException {
        Locale defaultLocale = this._portal.getSiteDefaultLocale(groupId);
        if (nameMap.isEmpty() || Validator.isNull((String)nameMap.get(defaultLocale))) {
            throw new SegmentsEntryNameException("Name is null for locale " + defaultLocale.getDisplayName());
        }
    }
}

