/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.provider;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.segments.context.Context;
import com.liferay.segments.internal.cache.SegmentsEntryCacheUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.provider.SegmentsEntryProvider;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={SegmentsEntryProviderRegistry.class})
public class SegmentsEntryProviderRegistryImpl
implements SegmentsEntryProviderRegistry {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryProviderRegistryImpl.class);
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    private ServiceTrackerList<SegmentsEntryProvider> _serviceTrackerList;
    private ServiceTrackerMap<String, SegmentsEntryProvider> _serviceTrackerMap;

    public long[] getSegmentsEntryClassPKs(long segmentsEntryId, int start, int end) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No segments entry found with segments entry ID " + segmentsEntryId));
            }
            return new long[0];
        }
        SegmentsEntryProvider segmentsEntryProvider = this.getSegmentsEntryProvider(segmentsEntry.getSource());
        if (segmentsEntryProvider == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No segments entry provider found for source " + segmentsEntry.getSource()));
            }
            return new long[0];
        }
        return segmentsEntryProvider.getSegmentsEntryClassPKs(segmentsEntryId, start, end);
    }

    public int getSegmentsEntryClassPKsCount(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No segments entry found with segments entry ID " + segmentsEntryId));
            }
            return 0;
        }
        SegmentsEntryProvider segmentsEntryProvider = this.getSegmentsEntryProvider(segmentsEntry.getSource());
        if (segmentsEntryProvider == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No segments entry provider found for source " + segmentsEntry.getSource()));
            }
            return 0;
        }
        return segmentsEntryProvider.getSegmentsEntryClassPKsCount(segmentsEntryId);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context, long[] segmentEntryIds) throws PortalException {
        String cacheKey = this._generateCacheKey(classPK, context);
        long[] cachedSegmentsEntryIds = SegmentsEntryCacheUtil.getSegmentsEntryIds(cacheKey);
        if (cachedSegmentsEntryIds != null) {
            return cachedSegmentsEntryIds;
        }
        long[] finalSegmentsEntryIds = new long[]{};
        for (SegmentsEntryProvider segmentsEntryProvider : this._serviceTrackerList) {
            finalSegmentsEntryIds = ArrayUtil.append((long[][])new long[][]{finalSegmentsEntryIds, segmentsEntryProvider.getSegmentsEntryIds(groupId, className, classPK, context, segmentEntryIds, finalSegmentsEntryIds)});
        }
        SegmentsEntryCacheUtil.putSegmentsEntryIds(cacheKey, finalSegmentsEntryIds);
        Set segmentsEntryIdsSet = SetUtil.fromArray((long[])finalSegmentsEntryIds);
        return ArrayUtil.toLongArray((Collection)segmentsEntryIdsSet);
    }

    public SegmentsEntryProvider getSegmentsEntryProvider(String source) {
        return (SegmentsEntryProvider)this._serviceTrackerMap.getService((Object)source);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, SegmentsEntryProvider.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("segments.entry.provider.order")));
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SegmentsEntryProvider.class, (String)"segments.entry.provider.source");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
        this._serviceTrackerMap.close();
    }

    private String _generateCacheKey(long classPK, Context context) {
        if (context == null) {
            return String.valueOf(classPK);
        }
        return String.valueOf(Objects.hash(classPK, GetterUtil.get((Object)context.get((Object)"browser"), (String)""), GetterUtil.get((Object)context.get((Object)"hostname"), (String)""), GetterUtil.get((Object)context.get((Object)"languageId"), (String)""), GetterUtil.get((Object)context.get((Object)"userAgent"), (String)"")));
    }
}

