/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.segments.model.impl;

import com.liferay.segments.model.SegmentsEntryRole;
import com.liferay.segments.service.SegmentsEntryRoleLocalServiceUtil;

/**
 * The extended model base implementation for the SegmentsEntryRole service. Represents a row in the &quot;SegmentsEntryRole&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SegmentsEntryRoleImpl}.
 * </p>
 *
 * @author Eduardo Garcia
 * @see SegmentsEntryRoleImpl
 * @see SegmentsEntryRole
 * @generated
 */
public abstract class SegmentsEntryRoleBaseImpl
	extends SegmentsEntryRoleModelImpl implements SegmentsEntryRole {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a segments entry role model instance should use the <code>SegmentsEntryRole</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SegmentsEntryRoleLocalServiceUtil.addSegmentsEntryRole(this);
		}
		else {
			SegmentsEntryRoleLocalServiceUtil.updateSegmentsEntryRole(this);
		}
	}

}