/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.search.spi.model.index.contributor;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.segments.model.SegmentsEntryRelModel;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={ModelDocumentContributor.class})
public class UserModelDocumentContributor
implements ModelDocumentContributor<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelDocumentContributor.class);
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;

    public void contribute(Document document, User user) {
        block4: {
            try {
                long[] segmentsEntryIds;
                long[] inheritedRoleIds = this._getInheritedRoleIds(user);
                if (ArrayUtil.isNotEmpty((long[])inheritedRoleIds)) {
                    document.addKeyword("inheritedRoleIds", inheritedRoleIds);
                }
                if (ArrayUtil.isNotEmpty((long[])(segmentsEntryIds = this._getSegmentsEntryIds(user)))) {
                    document.addKeyword("segmentsEntryIds", segmentsEntryIds);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to index user " + user.getUserId()), (Throwable)exception);
            }
        }
    }

    private long[] _getInheritedRoleIds(User user) throws Exception {
        return TransformUtil.transformToLongArray((Collection)user.getInheritedRoles(), RoleModel::getRoleId);
    }

    private long[] _getSegmentsEntryIds(User user) throws Exception {
        return TransformUtil.transformToLongArray((Collection)this._segmentsEntryRelLocalService.getSegmentsEntryRels(this._portal.getClassNameId(User.class), user.getUserId()), SegmentsEntryRelModel::getSegmentsEntryId);
    }
}

