/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.criteria.contributor;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.mapper.SegmentsCriteriaJSONObjectMapper;
import com.liferay.segments.field.Field;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"segments.criteria.contributor.key=user", "segments.criteria.contributor.model.class.name=com.liferay.portal.kernel.model.User", "segments.criteria.contributor.priority:Integer=10"}, service={SegmentsCriteriaContributor.class})
public class UserSegmentsCriteriaContributor
implements SegmentsCriteriaContributor {
    public static final String KEY = "user";
    private static final Pattern _pattern = Pattern.compile("roleIds eq '\\d+'");
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=User)")
    private volatile EntityModel _entityModel;
    @Reference
    private EntityModelFieldMapper _entityModelFieldMapper;
    @Reference(target="(segments.criteria.mapper.key=odata)")
    private SegmentsCriteriaJSONObjectMapper _segmentsCriteriaJSONObjectMapper;

    public void contribute(Criteria criteria, String filterString, Criteria.Conjunction conjunction) {
        criteria.addCriterion(this.getKey(), this.getType(), filterString, conjunction);
        String newFilterString = filterString;
        Matcher matcher = _pattern.matcher(filterString);
        while (matcher.find()) {
            newFilterString = StringUtil.replace((String)newFilterString, (String)matcher.group(), (String)String.join((CharSequence)"", "(", matcher.group(), " ", Criteria.Conjunction.OR.getValue(), " ", "inheritedRoleIds eq ", "'", String.valueOf(this._getRoleId(matcher.group())), "'", ")"));
        }
        criteria.addFilter(this.getType(), newFilterString, conjunction);
    }

    public JSONObject getCriteriaJSONObject(Criteria criteria) throws Exception {
        return this._segmentsCriteriaJSONObjectMapper.toJSONObject(criteria, (SegmentsCriteriaContributor)this);
    }

    public EntityModel getEntityModel() {
        return this._entityModel;
    }

    public String getEntityName() {
        return "User";
    }

    public List<Field> getFields(PortletRequest portletRequest) {
        return this._entityModelFieldMapper.getFields(this._entityModel, portletRequest);
    }

    public String getKey() {
        return KEY;
    }

    public Criteria.Type getType() {
        return Criteria.Type.MODEL;
    }

    private long _getRoleId(String criterionString) {
        int indexOf = criterionString.indexOf("'");
        int lastIndexOf = criterionString.lastIndexOf("'");
        if (indexOf == -1 || lastIndexOf == -1) {
            return -1L;
        }
        return GetterUtil.getLong((String)criterionString.substring(indexOf + 1, lastIndexOf));
    }
}

