/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.CollectionPropertyExpression;
import com.liferay.portal.odata.filter.expression.ComplexPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.LambdaVariableExpression;
import com.liferay.portal.odata.filter.expression.ListExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.PropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private final Date _date = new Date();
    private final EntityModel _entityModel;
    private int _groupCount;

    public ExpressionVisitorImpl(int groupCount, EntityModel entityModel) {
        this._groupCount = groupCount;
        this._entityModel = entityModel;
    }

    public Object visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) throws ExpressionVisitException {
        if (Objects.equals(BinaryExpression.Operation.AND, operation) || Objects.equals(BinaryExpression.Operation.OR, operation)) {
            return this._getConjunctionJSONObject(operation, (JSONObject)left, (JSONObject)right);
        }
        if (Objects.equals(BinaryExpression.Operation.EQ, operation) || Objects.equals(BinaryExpression.Operation.GE, operation) || Objects.equals(BinaryExpression.Operation.GT, operation) || Objects.equals(BinaryExpression.Operation.LE, operation) || Objects.equals(BinaryExpression.Operation.LT, operation) || Objects.equals(BinaryExpression.Operation.NE, operation)) {
            return this._getOperationJSONObject(String.valueOf(operation), left, right);
        }
        if (Objects.equals(BinaryExpression.Operation.SUB, operation)) {
            return this._sub(left, right);
        }
        throw new UnsupportedOperationException("Unsupported method visitBinaryExpressionOperation with operation " + operation);
    }

    public Object visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression) throws ExpressionVisitException {
        final LambdaFunctionExpression lambdaFunctionExpression = collectionPropertyExpression.getLambdaFunctionExpression();
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        final CollectionEntityField collectionEntityField = (CollectionEntityField)entityFieldsMap.get(collectionPropertyExpression.getName());
        return lambdaFunctionExpression.accept((ExpressionVisitor)new ExpressionVisitorImpl(0, new EntityModel(){

            public Map<String, EntityField> getEntityFieldsMap() {
                return Collections.singletonMap(lambdaFunctionExpression.getVariableName(), collectionEntityField.getEntityField());
            }

            public String getName() {
                return collectionEntityField.getName();
            }
        }));
    }

    public Object visitComplexPropertyExpression(ComplexPropertyExpression complexPropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        ComplexEntityField complexEntityField = (ComplexEntityField)entityFieldsMap.get(complexPropertyExpression.getName());
        Map complexEntityFieldFieldsMap = complexEntityField.getEntityFieldsMap();
        PropertyExpression propertyExpression = complexPropertyExpression.getPropertyExpression();
        EntityField entityField = (EntityField)complexEntityFieldFieldsMap.get(propertyExpression.getName());
        return complexEntityField.getName() + "/" + entityField.getName();
    }

    public Object visitLambdaFunctionExpression(LambdaFunctionExpression.Type type, String variable, Expression expression) throws ExpressionVisitException {
        if (type == LambdaFunctionExpression.Type.ANY) {
            return expression.accept((ExpressionVisitor)this);
        }
        throw new UnsupportedOperationException("Unsupported type visitLambdaFunctionExpression with type " + type);
    }

    public EntityField visitLambdaVariableExpression(LambdaVariableExpression lambdaVariableExpression) throws ExpressionVisitException {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        EntityField entityField = (EntityField)entityFieldsMap.get(lambdaVariableExpression.getVariableName());
        if (entityField == null) {
            throw new ExpressionVisitException("Invoked visitLambdaVariableExpression when no entity field is stored for lambda variable name " + lambdaVariableExpression.getVariableName());
        }
        return entityField;
    }

    public Object visitListExpressionOperation(ListExpression.Operation operation, Object left, List<Object> right) throws ExpressionVisitException {
        if (operation == ListExpression.Operation.IN) {
            return this._getOperationJSONObject(String.valueOf(operation), left, right);
        }
        throw new UnsupportedOperationException("Unsupported method visitListExpressionOperation with operation " + operation);
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) throws ExpressionVisitException {
        if (Objects.equals(LiteralExpression.Type.DURATION, literalExpression.getType())) {
            return this._getDuration(literalExpression.getText());
        }
        return StringUtil.unquote((String)literalExpression.getText());
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        if (type == MethodExpression.Type.CONTAINS) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method ", "type ", type, " and ", expressions.size(), "params"}));
            }
            return this._getOperationJSONObject(String.valueOf(type), expressions.get(0), expressions.get(1));
        }
        if (type == MethodExpression.Type.NOW) {
            if (!expressions.isEmpty()) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method ", "type ", type, " and ", expressions.size(), "params"}));
            }
            return MethodType.NOW;
        }
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return entityFieldsMap.get(primitivePropertyExpression.getName());
    }

    public JSONObject visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        if (Objects.equals(UnaryExpression.Operation.NOT, operation)) {
            JSONObject jsonObject = (JSONObject)operand;
            jsonObject.put("operatorName", StringUtil.lowerCase((String)(UnaryExpression.Operation.NOT + "-" + jsonObject.getString("operatorName"))));
            return jsonObject;
        }
        throw new UnsupportedOperationException("Unsupported method visitUnaryExpressionOperation with operation " + operation);
    }

    private JSONObject _getConjunctionJSONObject(BinaryExpression.Operation operation, JSONObject leftJSONObject, JSONObject rightJSONObject) {
        String conjunctionName = leftJSONObject.getString("conjunctionName");
        ++this._groupCount;
        if (Validator.isNotNull((String)conjunctionName)) {
            String operationString = operation.toString();
            if (Objects.equals(conjunctionName.toLowerCase(LocaleUtil.ROOT), operationString.toLowerCase(LocaleUtil.ROOT))) {
                return JSONUtil.put((String)"conjunctionName", (Object)StringUtil.lowerCase((String)String.valueOf(operation))).put("groupId", "group_" + this._groupCount).put("items", leftJSONObject.getJSONArray("items").put(rightJSONObject));
            }
        }
        return JSONUtil.put((String)"conjunctionName", (Object)StringUtil.lowerCase((String)String.valueOf(operation))).put("groupId", "group_" + this._groupCount).put("items", JSONUtil.putAll((Object[])new Object[]{leftJSONObject, rightJSONObject}));
    }

    private Duration _getDuration(String literal) throws ExpressionVisitException {
        literal = StringUtil.unquote((String)StringUtil.removeSubstring((String)literal, (String)"duration"));
        try {
            return Duration.parse(literal);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ExpressionVisitException("Invalid duration: " + dateTimeParseException.getMessage());
        }
    }

    private JSONObject _getOperationJSONObject(String operatorName, Object object, List<Object> fieldValues) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        fieldValues.forEach(fieldValue -> jsonArray.put(String.valueOf(fieldValue)));
        return JSONUtil.put((String)"operatorName", (Object)StringUtil.lowerCase((String)operatorName)).put("propertyName", this._getPropertyName(object)).put("value", jsonArray);
    }

    private JSONObject _getOperationJSONObject(String operatorName, Object object, Object fieldValue) {
        return JSONUtil.put((String)"operatorName", (Object)StringUtil.lowerCase((String)operatorName)).put("propertyName", this._getPropertyName(object)).put("value", fieldValue);
    }

    private String _getPropertyName(Object object) {
        if (object instanceof EntityField) {
            EntityField entityField = (EntityField)object;
            return entityField.getName();
        }
        return String.valueOf(object);
    }

    private Object _sub(Object left, Object right) throws ExpressionVisitException {
        if ((left instanceof MethodType || left instanceof String) && right instanceof Duration) {
            try {
                Date date = null;
                date = Objects.equals((Object)MethodType.NOW, left) ? this._date : ISO8601Utils.parse((String)String.valueOf(left), (ParsePosition)new ParsePosition(0));
                Duration duration = (Duration)right;
                Instant instant = date.toInstant();
                instant = instant.minusMillis(duration.toMillis());
                return ISO8601Utils.format((Date)Date.from(instant));
            }
            catch (ParseException parseException) {
                throw new ExpressionVisitException("Only a date with ISO 8601 format is supported as a left operator " + parseException.getMessage());
            }
        }
        throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported types in _sub with arithmetic operator SUB with ", "left type ", left.getClass(), " and right type ", right.getClass()}));
    }

    public static enum MethodType {
        NOW;

    }
}

