/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.configuration.provider.SegmentsConfigurationProvider;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.processor.SegmentsExperienceRequestProcessorRegistry;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class SegmentsServicePreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsServicePreAction.class);
    @Reference
    private Portal _portal;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private SegmentsConfigurationProvider _segmentsConfigurationProvider;
    @Reference
    private volatile SegmentsEntryRetriever _segmentsEntryRetriever;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperienceRequestProcessorRegistry _segmentsExperienceRequestProcessorRegistry;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            if (!this._segmentsConfigurationProvider.isSegmentationEnabled(this._portal.getCompanyId(httpServletRequest))) {
                return;
            }
            this._run(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    private long[] _getSegmentsExperienceIds(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long groupId, long userId, long plid) {
        try {
            long[] segmentsExperienceIds = this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(httpServletRequest, httpServletResponse, groupId, plid);
            HashSet<Long> segmentsExperienceIdsSegmentsEntryIds = new HashSet<Long>();
            for (long segmentsExperienceId : segmentsExperienceIds) {
                SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
                if (segmentsExperience != null) {
                    segmentsExperienceIdsSegmentsEntryIds.add(segmentsExperience.getSegmentsEntryId());
                    continue;
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to get segments experience " + segmentsExperienceId));
            }
            long[] cachedSegmentsEntryIds = (long[])httpServletRequest.getAttribute("SEGMENTS_ENTRY_IDS");
            long[] segmentsEntryIds = null;
            segmentsEntryIds = cachedSegmentsEntryIds != null ? cachedSegmentsEntryIds : this._segmentsEntryRetriever.getSegmentsEntryIds(groupId, userId, this._requestContextMapper.map(httpServletRequest), ArrayUtil.toArray((Long[])segmentsExperienceIdsSegmentsEntryIds.toArray(new Long[0])));
            httpServletRequest.setAttribute("SEGMENTS_ENTRY_IDS", (Object)segmentsEntryIds);
            return this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(httpServletRequest, httpServletResponse, groupId, plid, segmentsEntryIds);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return new long[]{this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(plid)};
        }
    }

    private void _run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isLifecycleRender()) {
            return;
        }
        Layout layout = themeDisplay.getLayout();
        if (layout == null || layout.isTypeControlPanel() || !layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            return;
        }
        httpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)this._getSegmentsExperienceIds(httpServletRequest, httpServletResponse, layout.getGroupId(), themeDisplay.getUserId(), layout.getPlid()));
    }
}

