/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.constants.SegmentsExperimentConstants;
import com.liferay.segments.exception.DuplicateSegmentsExperimentException;
import com.liferay.segments.exception.LockedSegmentsExperimentException;
import com.liferay.segments.exception.NoSuchExperimentException;
import com.liferay.segments.exception.RunSegmentsExperimentException;
import com.liferay.segments.exception.SegmentsExperimentConfidenceLevelException;
import com.liferay.segments.exception.SegmentsExperimentGoalException;
import com.liferay.segments.exception.SegmentsExperimentNameException;
import com.liferay.segments.exception.SegmentsExperimentRelSplitException;
import com.liferay.segments.exception.SegmentsExperimentStatusException;
import com.liferay.segments.exception.SegmentsExperimentTypeException;
import com.liferay.segments.exception.WinnerSegmentsExperienceException;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.SegmentsExperimentRel;
import com.liferay.segments.model.SegmentsExperimentRelTable;
import com.liferay.segments.model.SegmentsExperimentTable;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.SegmentsExperimentRelLocalService;
import com.liferay.segments.service.base.SegmentsExperimentLocalServiceBaseImpl;
import com.liferay.segments.service.persistence.SegmentsExperiencePersistence;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsExperiment"}, service={AopService.class})
public class SegmentsExperimentLocalServiceImpl
extends SegmentsExperimentLocalServiceBaseImpl {
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperiencePersistence _segmentsExperiencePersistence;
    @Reference
    private SegmentsExperimentRelLocalService _segmentsExperimentRelLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public SegmentsExperiment addSegmentsExperiment(long segmentsExperienceId, long plid, String name, String description, String goal, String goalTarget, ServiceContext serviceContext) throws PortalException {
        long segmentsExperimentId = this.counterLocalService.increment();
        int status = 0;
        this._validate(name, goal, status, status);
        this._validateDuplicateSegmentsExperiment(serviceContext.getScopeGroupId(), segmentsExperienceId, plid);
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentPersistence.create(segmentsExperimentId);
        segmentsExperiment.setUuid(serviceContext.getUuid());
        segmentsExperiment.setGroupId(serviceContext.getScopeGroupId());
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        segmentsExperiment.setCompanyId(user.getCompanyId());
        segmentsExperiment.setUserId(user.getUserId());
        segmentsExperiment.setUserName(user.getFullName());
        segmentsExperiment.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsExperiment.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsExperiment.setSegmentsExperienceId(segmentsExperienceId);
        segmentsExperiment.setSegmentsExperimentKey(String.valueOf(this.counterLocalService.increment()));
        segmentsExperiment.setPlid(plid);
        segmentsExperiment.setName(name);
        segmentsExperiment.setDescription(description);
        segmentsExperiment.setTypeSettings(UnicodePropertiesBuilder.create((boolean)true).put("goal", goal).put("goalTarget", goalTarget).buildString());
        segmentsExperiment.setStatus(status);
        segmentsExperiment = (SegmentsExperiment)this.segmentsExperimentPersistence.update((BaseModel)segmentsExperiment);
        this._resourceLocalService.addModelResources((AuditedModel)segmentsExperiment, serviceContext);
        this._segmentsExperimentRelLocalService.addSegmentsExperimentRel(segmentsExperiment.getSegmentsExperimentId(), segmentsExperiment.getSegmentsExperienceId(), serviceContext);
        return segmentsExperiment;
    }

    @Override
    public SegmentsExperiment deleteSegmentsExperiment(long segmentsExperimentId) throws PortalException {
        return this.deleteSegmentsExperiment(this.segmentsExperimentPersistence.findByPrimaryKey(segmentsExperimentId), false);
    }

    public SegmentsExperiment deleteSegmentsExperiment(long groupId, long segmentsExperienceId, long plid) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.fetchSegmentsExperiment(groupId, segmentsExperienceId, plid);
        return this.segmentsExperimentLocalService.deleteSegmentsExperiment(segmentsExperiment);
    }

    @Override
    @SystemEvent(type=1)
    public SegmentsExperiment deleteSegmentsExperiment(SegmentsExperiment segmentsExperiment) throws PortalException {
        return this.deleteSegmentsExperiment(segmentsExperiment, false);
    }

    @SystemEvent(type=1)
    public SegmentsExperiment deleteSegmentsExperiment(SegmentsExperiment segmentsExperiment, boolean force) throws PortalException {
        if (!force) {
            this._validateDeletableStatus(segmentsExperiment.getStatus());
        }
        this.segmentsExperimentPersistence.remove((BaseModel)segmentsExperiment);
        this._resourceLocalService.deleteResource((AuditedModel)segmentsExperiment, 4);
        this._segmentsExperimentRelLocalService.deleteSegmentsExperimentRels(segmentsExperiment.getSegmentsExperimentId());
        return segmentsExperiment;
    }

    public SegmentsExperiment fetchSegmentsExperiment(long groupId, long segmentsExperienceId, long plid) {
        List segmentsExperiments = (List)this.segmentsExperimentPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)SegmentsExperimentTable.INSTANCE).from((Table)SegmentsExperimentTable.INSTANCE).innerJoinON((Table)SegmentsExperimentRelTable.INSTANCE, SegmentsExperimentRelTable.INSTANCE.segmentsExperimentId.eq((Expression)SegmentsExperimentTable.INSTANCE.segmentsExperimentId)).where(SegmentsExperimentRelTable.INSTANCE.segmentsExperienceId.eq((Object)segmentsExperienceId).and((Expression)SegmentsExperimentTable.INSTANCE.groupId.eq((Object)groupId)).and((Expression)SegmentsExperimentTable.INSTANCE.plid.eq((Object)plid))));
        if (segmentsExperiments.isEmpty()) {
            return null;
        }
        return (SegmentsExperiment)segmentsExperiments.get(0);
    }

    public SegmentsExperiment fetchSegmentsExperiment(long groupId, String segmentsExperimentKey) {
        return this.segmentsExperimentPersistence.fetchByG_S(groupId, segmentsExperimentKey);
    }

    public List<SegmentsExperiment> getSegmentsEntrySegmentsExperiments(long segmentsEntryId) {
        DynamicQuery dynamicQuery = this.segmentsExperimentLocalService.dynamicQuery();
        Property segmentsExperienceIdProperty = PropertyFactoryUtil.forName((String)"segmentsExperienceId");
        dynamicQuery.add(segmentsExperienceIdProperty.in(this._getSegmentsExperienceIdsDynamicQuery(segmentsEntryId)));
        dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"createDate"));
        return this.segmentsExperimentLocalService.dynamicQuery(dynamicQuery);
    }

    public SegmentsExperiment getSegmentsExperiment(String segmentsExperimentKey) throws NoSuchExperimentException {
        return this.segmentsExperimentPersistence.findBySegmentsExperimentKey_First(segmentsExperimentKey, null);
    }

    public SegmentsExperiment runSegmentsExperiment(long segmentsExperimentId, double confidenceLevel, Map<Long, Double> segmentsExperienceIdSplitMap, String type) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentPersistence.findByPrimaryKey(segmentsExperimentId);
        this._validateEditableStatus(segmentsExperiment.getStatus());
        this._validateConfidenceLevel(confidenceLevel);
        this._validateSegmentsExperimentRels(segmentsExperienceIdSplitMap);
        this._validateSplit(segmentsExperienceIdSplitMap);
        this._validateType(type);
        UnicodeProperties typeSettingsUnicodeProperties = segmentsExperiment.getTypeSettingsProperties();
        this._validateGoalTarget((String)typeSettingsUnicodeProperties.get((Object)"goal"), (String)typeSettingsUnicodeProperties.get((Object)"goalTarget"));
        typeSettingsUnicodeProperties.setProperty("confidenceLevel", String.valueOf(confidenceLevel));
        typeSettingsUnicodeProperties.setProperty("type", type);
        segmentsExperiment.setTypeSettings(typeSettingsUnicodeProperties.toString());
        for (Map.Entry<Long, Double> segmentsExperienceIdSplit : segmentsExperienceIdSplitMap.entrySet()) {
            this._segmentsExperimentRelLocalService.updateSegmentsExperimentRel(segmentsExperimentId, segmentsExperienceIdSplit.getKey().longValue(), BigDecimalUtil.scale((Number)segmentsExperienceIdSplit.getValue(), (int)2, (RoundingMode)RoundingMode.HALF_DOWN));
        }
        return this._updateSegmentsExperimentStatus(segmentsExperiment, -1L, SegmentsExperimentConstants.Status.RUNNING.getValue());
    }

    public SegmentsExperiment updateSegmentsExperiment(long segmentsExperimentId, String name, String description, String goal, String goalTarget) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentPersistence.findByPrimaryKey(segmentsExperimentId);
        this._validateEditableStatus(segmentsExperiment.getStatus());
        this._validateGoal(goal);
        this._validateName(name);
        segmentsExperiment.setModifiedDate(new Date());
        segmentsExperiment.setName(name);
        segmentsExperiment.setDescription(description);
        UnicodeProperties typeSettingsUnicodeProperties = segmentsExperiment.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("goal", goal);
        typeSettingsUnicodeProperties.setProperty("goalTarget", goalTarget);
        segmentsExperiment.setTypeSettings(typeSettingsUnicodeProperties.toString());
        return (SegmentsExperiment)this.segmentsExperimentPersistence.update((BaseModel)segmentsExperiment);
    }

    public SegmentsExperiment updateSegmentsExperimentStatus(long segmentsExperimentId, int status) throws PortalException {
        return this._updateSegmentsExperimentStatus(this.segmentsExperimentPersistence.findByPrimaryKey(segmentsExperimentId), -1L, status);
    }

    public SegmentsExperiment updateSegmentsExperimentStatus(long segmentsExperimentId, long winnerSegmentsExperienceId, int status) throws PortalException {
        return this._updateSegmentsExperimentStatus(this.segmentsExperimentPersistence.findByPrimaryKey(segmentsExperimentId), winnerSegmentsExperienceId, status);
    }

    private DynamicQuery _getSegmentsExperienceIdsDynamicQuery(long segmentsEntryId) {
        DynamicQuery dynamicQuery = this._segmentsExperienceLocalService.dynamicQuery();
        Property segmentsEntryIdProperty = PropertyFactoryUtil.forName((String)"segmentsEntryId");
        dynamicQuery.add(segmentsEntryIdProperty.eq((Object)segmentsEntryId));
        dynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"segmentsExperienceId"));
        return dynamicQuery;
    }

    private SegmentsExperience _publishSegmentsExperienceVariant(SegmentsExperience controlSegmentsExperience, SegmentsExperience variantSegmentsExperience) {
        int originalPriority = controlSegmentsExperience.getPriority();
        SegmentsExperience segmentsExperience = this._segmentsExperiencePersistence.fetchByG_P_Last(controlSegmentsExperience.getGroupId(), controlSegmentsExperience.getPlid(), null);
        controlSegmentsExperience.setPriority(segmentsExperience.getPriority() - 1);
        controlSegmentsExperience.setActive(false);
        boolean controlSegmentsExperienceKeyDefault = Objects.equals("DEFAULT", controlSegmentsExperience.getSegmentsExperienceKey());
        if (controlSegmentsExperienceKeyDefault) {
            this._setSegmentsExperienceKeyProperty(controlSegmentsExperience);
            controlSegmentsExperience.setSegmentsExperienceKey(String.valueOf(this.counterLocalService.increment(SegmentsExperience.class.getName())));
        }
        this._segmentsExperienceLocalService.updateSegmentsExperience(controlSegmentsExperience);
        variantSegmentsExperience.setActive(true);
        variantSegmentsExperience = this._segmentsExperienceLocalService.updateSegmentsExperience(variantSegmentsExperience);
        long variantSegmentsExperienceId = variantSegmentsExperience.getSegmentsExperienceId();
        TransactionCommitCallbackUtil.registerCallback(() -> {
            SegmentsExperience callbackVariantSegmentsExperience = this._segmentsExperienceLocalService.getSegmentsExperience(variantSegmentsExperienceId);
            if (controlSegmentsExperienceKeyDefault) {
                callbackVariantSegmentsExperience.setSegmentsExperienceKey("DEFAULT");
            }
            callbackVariantSegmentsExperience.setPriority(originalPriority);
            this._segmentsExperienceLocalService.updateSegmentsExperience(callbackVariantSegmentsExperience);
            return null;
        });
        return variantSegmentsExperience;
    }

    private void _sendNotificationEvent(SegmentsExperiment segmentsExperiment) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null || serviceContext.getUserId() == segmentsExperiment.getUserId() || !UserNotificationManagerUtil.isDeliver((long)segmentsExperiment.getUserId(), (String)"com_liferay_segments_experiment_web_internal_portlet_SegmentsExperimentPortlet", (long)0L, (int)0, (int)10002)) {
            return;
        }
        this._userNotificationEventLocalService.sendUserNotificationEvents(segmentsExperiment.getUserId(), "com_liferay_segments_experiment_web_internal_portlet_SegmentsExperimentPortlet", 10002, JSONUtil.put((String)"classPK", (Object)segmentsExperiment.getSegmentsExperimentId()).put("referrerClassNameId", this._portal.getClassNameId(Layout.class.getName())).put("referrerClassPK", segmentsExperiment.getPlid()).put("segmentsExperimentKey", segmentsExperiment.getSegmentsExperimentKey()));
    }

    private void _setSegmentsExperienceKeyProperty(SegmentsExperience segmentsExperience) {
        UnicodeProperties typeSettingsUnicodeProperties = segmentsExperience.getTypeSettingsUnicodeProperties();
        typeSettingsUnicodeProperties.setProperty("segmentsExperimentSegmentsExperienceKey", segmentsExperience.getSegmentsExperienceKey());
        segmentsExperience.setTypeSettingsUnicodeProperties(typeSettingsUnicodeProperties);
    }

    private SegmentsExperiment _updateSegmentsExperimentStatus(SegmentsExperiment segmentsExperiment, long winnerSegmentsExperienceId, int status) throws PortalException {
        this._validateStatus(segmentsExperiment.getStatus(), status, winnerSegmentsExperienceId);
        if (winnerSegmentsExperienceId != -1L) {
            this._updateWinnerSegmentsExperienceId(segmentsExperiment, winnerSegmentsExperienceId, status);
        }
        segmentsExperiment.setModifiedDate(new Date());
        segmentsExperiment.setStatus(status);
        segmentsExperiment = (SegmentsExperiment)this.segmentsExperimentPersistence.update((BaseModel)segmentsExperiment);
        this._sendNotificationEvent(segmentsExperiment);
        return segmentsExperiment;
    }

    private SegmentsExperiment _updateWinnerSegmentsExperienceId(SegmentsExperiment segmentsExperiment, long winnerSegmentsExperienceId, int status) throws PortalException {
        SegmentsExperimentRel segmentsExperimentRel = this._segmentsExperimentRelLocalService.fetchSegmentsExperimentRel(segmentsExperiment.getSegmentsExperimentId(), winnerSegmentsExperienceId);
        if (segmentsExperimentRel == null) {
            throw new WinnerSegmentsExperienceException("Winner segments experience " + winnerSegmentsExperienceId + " no found");
        }
        UnicodeProperties typeSettingsUnicodeProperties = segmentsExperiment.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("winnerSegmentsExperienceId", String.valueOf(winnerSegmentsExperienceId));
        segmentsExperiment.setTypeSettings(typeSettingsUnicodeProperties.toString());
        SegmentsExperimentConstants.Status statusObject = SegmentsExperimentConstants.Status.valueOf((int)status);
        if ((statusObject == SegmentsExperimentConstants.Status.COMPLETED || statusObject == SegmentsExperimentConstants.Status.TERMINATED) && winnerSegmentsExperienceId != segmentsExperiment.getSegmentsExperienceId()) {
            this._publishSegmentsExperienceVariant(this._segmentsExperienceLocalService.getSegmentsExperience(segmentsExperiment.getSegmentsExperienceId()), this._segmentsExperienceLocalService.getSegmentsExperience(winnerSegmentsExperienceId));
        }
        return segmentsExperiment;
    }

    private void _validate(String name, String goal, int currentStatus, int newStatus) throws PortalException {
        this._validateGoal(goal);
        this._validateName(name);
        this._validateStatus(currentStatus, newStatus, -1L);
    }

    private void _validateConfidenceLevel(double confidenceLevel) throws PortalException {
        if (confidenceLevel < 0.8 || confidenceLevel > 0.99) {
            throw new SegmentsExperimentConfidenceLevelException("Confidence level " + confidenceLevel + " is not a value between 0.8 and 0.99");
        }
    }

    private void _validateDeletableStatus(int status) throws PortalException {
        SegmentsExperimentConstants.Status statusObject = SegmentsExperimentConstants.Status.valueOf((int)status);
        if (!statusObject.isDeletable()) {
            throw new LockedSegmentsExperimentException("Segments experiment is not deletable in status " + statusObject);
        }
    }

    private void _validateDuplicateSegmentsExperiment(long groupId, long segmentsExperienceId, long plid) throws PortalException {
        SegmentsExperiment segmentsExperiment = this.segmentsExperimentLocalService.fetchSegmentsExperiment(groupId, segmentsExperienceId, plid);
        if (segmentsExperiment == null) {
            return;
        }
        throw new DuplicateSegmentsExperimentException();
    }

    private void _validateEditableStatus(int status) throws PortalException {
        SegmentsExperimentConstants.Status statusObject = SegmentsExperimentConstants.Status.valueOf((int)status);
        if (!statusObject.isEditable()) {
            throw new LockedSegmentsExperimentException("Segments experiment is not editable in status " + statusObject);
        }
    }

    private void _validateGoal(String goal) throws PortalException {
        if (SegmentsExperimentConstants.Goal.parse((String)goal) == null) {
            throw new SegmentsExperimentGoalException();
        }
    }

    private void _validateGoalTarget(String goal, String goalTarget) throws PortalException {
        if (goal.equals(SegmentsExperimentConstants.Goal.CLICK_RATE.getLabel()) && Validator.isNull((String)goalTarget)) {
            throw new RunSegmentsExperimentException("Target element needs to be set in click goal");
        }
    }

    private void _validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new SegmentsExperimentNameException();
        }
    }

    private void _validateSegmentsExperimentRels(Map<Long, Double> segmentsExperienceIdSplitMap) throws PortalException {
        if (segmentsExperienceIdSplitMap.size() <= 1) {
            throw new RunSegmentsExperimentException("Segments experiment rels must be more than 1 to test against control");
        }
    }

    private void _validateSplit(Map<Long, Double> segmentsExperienceIdSplitMap) throws PortalException {
        double segmentsExperienceIdSplitsSum = 0.0;
        Collection<Double> segmentsExperienceIdSplitsValues = segmentsExperienceIdSplitMap.values();
        for (Double segmentsExperienceIdSplitsValue : segmentsExperienceIdSplitsValues) {
            segmentsExperienceIdSplitsSum += BigDecimalUtil.scale((Number)segmentsExperienceIdSplitsValue, (int)2, (RoundingMode)RoundingMode.HALF_DOWN);
        }
        if (segmentsExperienceIdSplitsSum != 1.0) {
            throw new SegmentsExperimentRelSplitException("Segments experiment rel splits must add up to 1");
        }
    }

    private void _validateStatus(int status, int newStatus, long winnerSegmentsExperienceId) throws SegmentsExperimentStatusException {
        SegmentsExperimentConstants.Status.validateTransition((int)status, (int)newStatus);
        SegmentsExperimentConstants.Status newStatusObject = SegmentsExperimentConstants.Status.valueOf((int)newStatus);
        if (newStatusObject.requiresWinnerExperience() && winnerSegmentsExperienceId < 0L) {
            throw new SegmentsExperimentStatusException(StringBundler.concat((String[])new String[]{"Status ", newStatusObject.name(), " requires a winner segments experience"}));
        }
    }

    private void _validateType(String type) throws PortalException {
        if (SegmentsExperimentConstants.Type.parse((String)type) == null) {
            throw new SegmentsExperimentTypeException();
        }
    }
}

