/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.segments.constants.SegmentsEntryConstants;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperimentRel;
import com.liferay.segments.model.impl.SegmentsExperimentBaseImpl;
import com.liferay.segments.service.SegmentsEntryLocalServiceUtil;
import com.liferay.segments.service.SegmentsExperienceLocalServiceUtil;
import com.liferay.segments.service.SegmentsExperimentRelLocalServiceUtil;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class SegmentsExperimentImpl
extends SegmentsExperimentBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsExperimentImpl.class);
    private UnicodeProperties _typeSettingsUnicodeProperties;

    public double getConfidenceLevel() {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return GetterUtil.getDouble((String)typeSettingsUnicodeProperties.getProperty("confidenceLevel"));
    }

    public String getGoal() {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return GetterUtil.getString((String)typeSettingsUnicodeProperties.getProperty("goal"));
    }

    public String getGoalTarget() {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return GetterUtil.getString((String)typeSettingsUnicodeProperties.getProperty("goalTarget"));
    }

    public String getSegmentsEntryName(Locale locale) throws PortalException {
        if (this.getSegmentsExperienceId() == 0L) {
            return SegmentsEntryConstants.getDefaultSegmentsEntryName((Locale)locale);
        }
        SegmentsExperience segmentsExperience = SegmentsExperienceLocalServiceUtil.getSegmentsExperience((long)this.getSegmentsExperienceId());
        if (segmentsExperience.getSegmentsEntryId() == 0L) {
            return SegmentsEntryConstants.getDefaultSegmentsEntryName((Locale)locale);
        }
        SegmentsEntry segmentsEntry = SegmentsEntryLocalServiceUtil.getSegmentsEntry((long)segmentsExperience.getSegmentsEntryId());
        return segmentsEntry.getName(locale);
    }

    public String getSegmentsExperienceKey() {
        SegmentsExperience segmentsExperience = SegmentsExperienceLocalServiceUtil.fetchSegmentsExperience((long)this.getSegmentsExperienceId());
        if (segmentsExperience != null) {
            return segmentsExperience.getSegmentsExperienceKey();
        }
        return "DEFAULT";
    }

    public List<SegmentsExperimentRel> getSegmentsExperimentRels() {
        return SegmentsExperimentRelLocalServiceUtil.getSegmentsExperimentRels((long)this.getSegmentsExperimentId());
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsUnicodeProperties == null) {
            this._typeSettingsUnicodeProperties = new UnicodeProperties(true);
            try {
                this._typeSettingsUnicodeProperties.load(super.getTypeSettings());
            }
            catch (IOException ioException) {
                _log.error((Object)ioException, (Throwable)ioException);
            }
        }
        return this._typeSettingsUnicodeProperties;
    }

    public long getWinnerSegmentsExperienceId() {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("winnerSegmentsExperienceId"), (long)-1L);
    }

    public String getWinnerSegmentsExperienceKey() {
        long winnerSegmentsExperienceId = this.getWinnerSegmentsExperienceId();
        if (winnerSegmentsExperienceId < 0L) {
            return "";
        }
        SegmentsExperience winnerSegmentsExperience = SegmentsExperienceLocalServiceUtil.fetchSegmentsExperience((long)winnerSegmentsExperienceId);
        if (winnerSegmentsExperience != null) {
            return winnerSegmentsExperience.getSegmentsExperienceKey();
        }
        return "DEFAULT";
    }
}

