/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryModel;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class SegmentsEntryModelResourcePermissionRegistrar {
    @Reference(target="(resource.name=com.liferay.segments)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    private ServiceRegistration<ModelResourcePermission<SegmentsEntry>> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;

    @Activate
    protected void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", SegmentsEntry.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(SegmentsEntry.class, SegmentsEntryModel::getSegmentsEntryId, arg_0 -> ((SegmentsEntryLocalService)this._segmentsEntryLocalService).getSegmentsEntry(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> consumer.accept(new StagedModelResourcePermissionLogic(this._stagingPermission))), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private static class StagedModelResourcePermissionLogic
    implements ModelResourcePermissionLogic<SegmentsEntry> {
        private final StagingPermission _stagingPermission;

        public Boolean contains(PermissionChecker permissionChecker, String name, SegmentsEntry segmentsEntry, String actionId) throws PortalException {
            if (actionId.equals("UPDATE") && "ASAH_FARO_BACKEND".equals(segmentsEntry.getSource())) {
                return false;
            }
            return this._stagingPermission.hasPermission(permissionChecker, segmentsEntry.getGroupId(), SegmentsEntry.class.getName(), segmentsEntry.getSegmentsEntryId(), "com_liferay_segments_web_internal_portlet_SegmentsPortlet", actionId);
        }

        private StagedModelResourcePermissionLogic(StagingPermission stagingPermission) {
            this._stagingPermission = stagingPermission;
        }
    }
}

