/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.security.permission.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsEntryRole;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryRoleLocalService;
import com.liferay.segments.simulator.SegmentsEntrySimulator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={RoleContributor.class})
public class SegmentsEntryRoleContributor
implements RoleContributor {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryRoleContributor.class);
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference
    private SegmentsEntryRoleLocalService _segmentsEntryRoleLocalService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private volatile SegmentsEntrySimulator _segmentsEntrySimulator;

    public void contribute(RoleCollection roleCollection) {
        for (long segmentsEntryId : this._getSegmentsEntryIds(roleCollection)) {
            List segmentsEntryRoles = this._segmentsEntryRoleLocalService.getSegmentsEntryRoles(segmentsEntryId);
            for (SegmentsEntryRole segmentsEntryRole : segmentsEntryRoles) {
                roleCollection.addRoleId(segmentsEntryRole.getRoleId());
            }
        }
    }

    private long[] _getSegmentsEntryIds(RoleCollection roleCollection) {
        User user;
        long[] segmentsEntryIds;
        block7: {
            segmentsEntryIds = new long[]{};
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext == null) {
                return segmentsEntryIds;
            }
            HttpServletRequest httpServletRequest = serviceContext.getRequest();
            if (httpServletRequest == null) {
                return segmentsEntryIds;
            }
            user = roleCollection.getUser();
            if (this._segmentsEntrySimulator != null && this._segmentsEntrySimulator.isSimulationActive(user.getUserId())) {
                segmentsEntryIds = this._segmentsEntrySimulator.getSimulatedSegmentsEntryIds(user.getUserId());
            } else {
                try {
                    segmentsEntryIds = this._segmentsEntryProviderRegistry.getSegmentsEntryIds(roleCollection.getGroupId(), User.class.getName(), user.getUserId(), this._requestContextMapper.map(httpServletRequest));
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)portalException.getMessage());
                }
            }
        }
        if (segmentsEntryIds.length > 0 && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Found segments ", segmentsEntryIds, " for user ", user.getUserId(), " in group ", roleCollection.getGroupId()}));
        }
        return segmentsEntryIds;
    }
}

